package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * dataphin派生指标信息
 *
 * @author auto create
 * @since 1.0, 2021-09-09 14:46:37
 */
public class DerivedIndexDTO extends AlipayObject {

	private static final long serialVersionUID = 3241372412866289322L;

	/**
	 * 指标中文名
	 */
	@ApiField("cn")
	private String cn;

	/**
	 * 派生指标计算逻辑表达式，即页面上指标计算sql
	 */
	@ApiField("logic")
	private String logic;

	/**
	 * dataphin派生指标名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 原子指标对象
	 */
	@ApiField("parent_atomic_index")
	private DerivedIndexParentDTO parentAtomicIndex;

	/**
	 * 时间周期
	 */
	@ApiField("stat_period")
	private TimePeriodDTO statPeriod;

	public String getCn() {
		return this.cn;
	}
	public void setCn(String cn) {
		this.cn = cn;
	}

	public String getLogic() {
		return this.logic;
	}
	public void setLogic(String logic) {
		this.logic = logic;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public DerivedIndexParentDTO getParentAtomicIndex() {
		return this.parentAtomicIndex;
	}
	public void setParentAtomicIndex(DerivedIndexParentDTO parentAtomicIndex) {
		this.parentAtomicIndex = parentAtomicIndex;
	}

	public TimePeriodDTO getStatPeriod() {
		return this.statPeriod;
	}
	public void setStatPeriod(TimePeriodDTO statPeriod) {
		this.statPeriod = statPeriod;
	}

}
