package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 企业账户基本信息VO
 *
 * @author auto create
 * @since 1.0, 2021-09-27 18:54:55
 */
public class CoopAcctBaseInfoVo extends AlipayObject {

	private static final long serialVersionUID = 2685933162186627771L;

	/**
	 * 账户生命周期状态
	 */
	@ApiField("account_lifecycle_status")
	private String accountLifecycleStatus;

	/**
	 * 账户状态
	 */
	@ApiField("account_status")
	private String accountStatus;

	/**
	 * 开户状态
	 */
	@ApiField("bsn_st")
	private String bsnSt;

	/**
	 * 基本户核验状态
	 */
	@ApiField("check_state")
	private String checkState;

	/**
	 * 是否销户
	 */
	@ApiField("del_or_not")
	private String delOrNot;

	/**
	 * 外部业务id,支付宝uid等
	 */
	@ApiField("external_biz_id")
	private String externalBizId;

	/**
	 * ipid
	 */
	@ApiField("ip_id")
	private String ipId;

	/**
	 * 网商会员id
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 没做基本户核验
	 */
	@ApiField("no_approval_check")
	private Boolean noApprovalCheck;

	/**
	 * 开户类型,企支和法人标识
	 */
	@ApiField("open_account_flow_type")
	private String openAccountFlowType;

	/**
	 * 开户时间
	 */
	@ApiField("open_date")
	private String openDate;

	public String getAccountLifecycleStatus() {
		return this.accountLifecycleStatus;
	}
	public void setAccountLifecycleStatus(String accountLifecycleStatus) {
		this.accountLifecycleStatus = accountLifecycleStatus;
	}

	public String getAccountStatus() {
		return this.accountStatus;
	}
	public void setAccountStatus(String accountStatus) {
		this.accountStatus = accountStatus;
	}

	public String getBsnSt() {
		return this.bsnSt;
	}
	public void setBsnSt(String bsnSt) {
		this.bsnSt = bsnSt;
	}

	public String getCheckState() {
		return this.checkState;
	}
	public void setCheckState(String checkState) {
		this.checkState = checkState;
	}

	public String getDelOrNot() {
		return this.delOrNot;
	}
	public void setDelOrNot(String delOrNot) {
		this.delOrNot = delOrNot;
	}

	public String getExternalBizId() {
		return this.externalBizId;
	}
	public void setExternalBizId(String externalBizId) {
		this.externalBizId = externalBizId;
	}

	public String getIpId() {
		return this.ipId;
	}
	public void setIpId(String ipId) {
		this.ipId = ipId;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public Boolean getNoApprovalCheck() {
		return this.noApprovalCheck;
	}
	public void setNoApprovalCheck(Boolean noApprovalCheck) {
		this.noApprovalCheck = noApprovalCheck;
	}

	public String getOpenAccountFlowType() {
		return this.openAccountFlowType;
	}
	public void setOpenAccountFlowType(String openAccountFlowType) {
		this.openAccountFlowType = openAccountFlowType;
	}

	public String getOpenDate() {
		return this.openDate;
	}
	public void setOpenDate(String openDate) {
		this.openDate = openDate;
	}

}
