package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 合同签约实体
 *
 * @author auto create
 * @since 1.0, 2022-11-10 10:43:04
 */
public class ContractSignEntity extends AlipayObject {

	private static final long serialVersionUID = 6375854525666845812L;

	/**
	 * 合同类型
	 */
	@ApiField("contract_type")
	private String contractType;

	/**
	 * 签约人支付宝登录号
	 */
	@ApiField("sign_alipay_login_id")
	private String signAlipayLoginId;

	/**
	 * 签约人支付宝id
	 */
	@ApiField("sign_alipay_user_id")
	private String signAlipayUserId;

	/**
	 * 签约人开放平台openId,从用户信息接口中获取
	 */
	@ApiField("sign_open_id")
	private String signOpenId;

	public String getContractType() {
		return this.contractType;
	}
	public void setContractType(String contractType) {
		this.contractType = contractType;
	}

	public String getSignAlipayLoginId() {
		return this.signAlipayLoginId;
	}
	public void setSignAlipayLoginId(String signAlipayLoginId) {
		this.signAlipayLoginId = signAlipayLoginId;
	}

	public String getSignAlipayUserId() {
		return this.signAlipayUserId;
	}
	public void setSignAlipayUserId(String signAlipayUserId) {
		this.signAlipayUserId = signAlipayUserId;
	}

	public String getSignOpenId() {
		return this.signOpenId;
	}
	public void setSignOpenId(String signOpenId) {
		this.signOpenId = signOpenId;
	}

}
