package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * Company
 *
 * @author auto create
 * @since 1.0, 2022-04-01 15:17:19
 */
public class Company extends AlipayObject {

	private static final long serialVersionUID = 1266684178448661459L;

	/**
	 * aa
	 */
	@ApiListField("attachments")
	@ApiField("ic_attachment")
	private List<IcAttachment> attachments;

	/**
	 * Certificates
	 */
	@ApiListField("certificates")
	@ApiField("ic_certificate")
	private List<IcCertificate> certificates;

	/**
	 * COMPANY；SOLE_PROPRIETORSHIP_ENTERPRISE；PARTNERSHIP；INDIVIDUAL；ENTERPRISE
	 */
	@ApiField("companytype")
	private String companytype;

	/**
	 * Contact methods
	 */
	@ApiListField("contactways")
	@ApiField("ic_contact_way")
	private List<IcContactWay> contactways;

	/**
	 * IPO;UNIPO
	 */
	@ApiField("enterprisetype")
	private String enterprisetype;

	/**
	 * This field ontains two keys in JSON format:
	 */
	@ApiField("extendinfo")
	private String extendinfo;

	/**
	 * FundsSource 资金来源
	 */
	@ApiListField("fundssources")
	@ApiField("string")
	private List<String> fundssources;

	/**
	 * Legal name
	 */
	@ApiField("legalname")
	private String legalname;

	/**
	 * Registration address
	 */
	@ApiField("registrationaddress")
	private IcAddress registrationaddress;

	/**
	 * 注册日期
	 */
	@ApiField("registrationdate")
	private Date registrationdate;

	/**
	 * 公司注册号
	 */
	@ApiField("registrationno")
	private String registrationno;

	/**
	 * TAX_IDENTIFICATION_NUMBER;UNIFIED_SOCIAL_CREDIT_ID;ENTERPRISE_REGISTRATION;US_FEDERAL_EIN;ID_CARD;OTHER_MATERIAL
	 */
	@ApiField("registrationtype")
	private String registrationtype;

	/**
	 * 公司员工数
	 */
	@ApiField("staffnumber")
	private Long staffnumber;

	/**
	 * Stock code
	 */
	@ApiField("stockcode")
	private String stockcode;

	/**
	 * Location country of the stock. Country or region as defined by two-character ISO 3166 country/region code.
	 */
	@ApiField("stockmarket")
	private String stockmarket;

	/**
	 * taxNo 税号
	 */
	@ApiField("taxno")
	private String taxno;

	/**
	 * vatNo  增值税税号
	 */
	@ApiField("vatno")
	private String vatno;

	/**
	 * WealthSource wealthSources  财富来源
	 */
	@ApiListField("wealthsources")
	@ApiField("string")
	private List<String> wealthsources;

	public List<IcAttachment> getAttachments() {
		return this.attachments;
	}
	public void setAttachments(List<IcAttachment> attachments) {
		this.attachments = attachments;
	}

	public List<IcCertificate> getCertificates() {
		return this.certificates;
	}
	public void setCertificates(List<IcCertificate> certificates) {
		this.certificates = certificates;
	}

	public String getCompanytype() {
		return this.companytype;
	}
	public void setCompanytype(String companytype) {
		this.companytype = companytype;
	}

	public List<IcContactWay> getContactways() {
		return this.contactways;
	}
	public void setContactways(List<IcContactWay> contactways) {
		this.contactways = contactways;
	}

	public String getEnterprisetype() {
		return this.enterprisetype;
	}
	public void setEnterprisetype(String enterprisetype) {
		this.enterprisetype = enterprisetype;
	}

	public String getExtendinfo() {
		return this.extendinfo;
	}
	public void setExtendinfo(String extendinfo) {
		this.extendinfo = extendinfo;
	}

	public List<String> getFundssources() {
		return this.fundssources;
	}
	public void setFundssources(List<String> fundssources) {
		this.fundssources = fundssources;
	}

	public String getLegalname() {
		return this.legalname;
	}
	public void setLegalname(String legalname) {
		this.legalname = legalname;
	}

	public IcAddress getRegistrationaddress() {
		return this.registrationaddress;
	}
	public void setRegistrationaddress(IcAddress registrationaddress) {
		this.registrationaddress = registrationaddress;
	}

	public Date getRegistrationdate() {
		return this.registrationdate;
	}
	public void setRegistrationdate(Date registrationdate) {
		this.registrationdate = registrationdate;
	}

	public String getRegistrationno() {
		return this.registrationno;
	}
	public void setRegistrationno(String registrationno) {
		this.registrationno = registrationno;
	}

	public String getRegistrationtype() {
		return this.registrationtype;
	}
	public void setRegistrationtype(String registrationtype) {
		this.registrationtype = registrationtype;
	}

	public Long getStaffnumber() {
		return this.staffnumber;
	}
	public void setStaffnumber(Long staffnumber) {
		this.staffnumber = staffnumber;
	}

	public String getStockcode() {
		return this.stockcode;
	}
	public void setStockcode(String stockcode) {
		this.stockcode = stockcode;
	}

	public String getStockmarket() {
		return this.stockmarket;
	}
	public void setStockmarket(String stockmarket) {
		this.stockmarket = stockmarket;
	}

	public String getTaxno() {
		return this.taxno;
	}
	public void setTaxno(String taxno) {
		this.taxno = taxno;
	}

	public String getVatno() {
		return this.vatno;
	}
	public void setVatno(String vatno) {
		this.vatno = vatno;
	}

	public List<String> getWealthsources() {
		return this.wealthsources;
	}
	public void setWealthsources(List<String> wealthsources) {
		this.wealthsources = wealthsources;
	}

}
