package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 退收费规则
 *
 * @author auto create
 * @since 1.0, 2022-11-12 15:49:04
 */
public class ChargeRuleVO extends AlipayObject {

	private static final long serialVersionUID = 2233378616997114297L;

	/**
	 * 计费规则
	 */
	@ApiField("chargerule")
	private String chargerule;

	/**
	 * 费用项Id
	 */
	@ApiField("feeitemid")
	private String feeitemid;

	/**
	 * 计费周期(退费规则场景为退费期限)
	 */
	@ApiField("period")
	private String period;

	/**
	 * 计费规则code
	 */
	@ApiField("rulecode")
	private String rulecode;

	/**
	 * 退收费规则类型
	 */
	@ApiField("ruletype")
	private String ruletype;

	/**
	 * 是否签约指定
	 */
	@ApiField("settingbysign")
	private Boolean settingbysign;

	public String getChargerule() {
		return this.chargerule;
	}
	public void setChargerule(String chargerule) {
		this.chargerule = chargerule;
	}

	public String getFeeitemid() {
		return this.feeitemid;
	}
	public void setFeeitemid(String feeitemid) {
		this.feeitemid = feeitemid;
	}

	public String getPeriod() {
		return this.period;
	}
	public void setPeriod(String period) {
		this.period = period;
	}

	public String getRulecode() {
		return this.rulecode;
	}
	public void setRulecode(String rulecode) {
		this.rulecode = rulecode;
	}

	public String getRuletype() {
		return this.ruletype;
	}
	public void setRuletype(String ruletype) {
		this.ruletype = ruletype;
	}

	public Boolean getSettingbysign() {
		return this.settingbysign;
	}
	public void setSettingbysign(Boolean settingbysign) {
		this.settingbysign = settingbysign;
	}

}
