package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * BusinessContactEntity
 *
 * @author auto create
 * @since 1.0, 2022-04-01 15:58:26
 */
public class BusinessContactEntity extends AlipayObject {

	private static final long serialVersionUID = 4253794626623633255L;

	/**
	 * DIRECTOR ; SHAREHOLDER;ENTITY_SHAREHOLDER;BOARD_MEMBER;UBO;LEGAL_REPRESENTATIVE;AUTHORIZED_SIGNATORY;COMMON;CONTROLLER;
	 */
	@ApiField("businesscontacttype")
	private String businesscontacttype;

	/**
	 * company
	 */
	@ApiField("company")
	private Company company;

	/**
	 * FundsSource资金来源
	 */
	@ApiListField("fundssources")
	@ApiField("string")
	private List<String> fundssources;

	/**
	 * individual
	 */
	@ApiField("individual")
	private Individual individual;

	/**
	 * INDIVIDUAL;COMPANY
	 */
	@ApiField("legalentitytype")
	private String legalentitytype;

	/**
	 * The shareholder equity ratio. Use decimal for percentage. For example, 10 = 10%.
	 */
	@ApiField("shareholdingratio")
	private String shareholdingratio;

	public String getBusinesscontacttype() {
		return this.businesscontacttype;
	}
	public void setBusinesscontacttype(String businesscontacttype) {
		this.businesscontacttype = businesscontacttype;
	}

	public Company getCompany() {
		return this.company;
	}
	public void setCompany(Company company) {
		this.company = company;
	}

	public List<String> getFundssources() {
		return this.fundssources;
	}
	public void setFundssources(List<String> fundssources) {
		this.fundssources = fundssources;
	}

	public Individual getIndividual() {
		return this.individual;
	}
	public void setIndividual(Individual individual) {
		this.individual = individual;
	}

	public String getLegalentitytype() {
		return this.legalentitytype;
	}
	public void setLegalentitytype(String legalentitytype) {
		this.legalentitytype = legalentitytype;
	}

	public String getShareholdingratio() {
		return this.shareholdingratio;
	}
	public void setShareholdingratio(String shareholdingratio) {
		this.shareholdingratio = shareholdingratio;
	}

}
