package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 子文件受理状态
 *
 * @author auto create
 * @since 1.0, 2023-03-22 19:01:58
 */
public class BulkSealResult extends AlipayObject {

	private static final long serialVersionUID = 4216246597979683159L;

	/**
	 * 签署方信息
	 */
	@ApiListField("bulk_seal_operators")
	@ApiField("bulk_seal_operator_v_o")
	private List<BulkSealOperatorVO> bulkSealOperators;

	/**
	 * 唯一业务标识号，使用法务中台电子用印服务的各系统需要保证此字段的唯一性，不传则签章中心默认生成
	 */
	@ApiField("business_unique_id")
	private String businessUniqueId;

	/**
	 * 受理失败errorCode
	 */
	@ApiField("error_code")
	private String errorCode;

	/**
	 * 受理失败errorMessage
	 */
	@ApiField("error_message")
	private String errorMessage;

	/**
	 * 签章中心流水id
	 */
	@ApiField("file_id")
	private String fileId;

	/**
	 * 文件名
	 */
	@ApiField("file_name")
	private String fileName;

	/**
	 * 用完印的文件filekey
	 */
	@ApiField("final_file_oss_addr")
	private String finalFileOssAddr;

	/**
	 * 签章中心流水id
	 */
	@ApiField("seal_request_id")
	private String sealRequestId;

	/**
	 * 签署完成时间
	 */
	@ApiField("signed_time")
	private Date signedTime;

	/**
	 * 是否受理成功
	 */
	@ApiField("status")
	private Boolean status;

	public List<BulkSealOperatorVO> getBulkSealOperators() {
		return this.bulkSealOperators;
	}
	public void setBulkSealOperators(List<BulkSealOperatorVO> bulkSealOperators) {
		this.bulkSealOperators = bulkSealOperators;
	}

	public String getBusinessUniqueId() {
		return this.businessUniqueId;
	}
	public void setBusinessUniqueId(String businessUniqueId) {
		this.businessUniqueId = businessUniqueId;
	}

	public String getErrorCode() {
		return this.errorCode;
	}
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorMessage() {
		return this.errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getFileId() {
		return this.fileId;
	}
	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getFileName() {
		return this.fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFinalFileOssAddr() {
		return this.finalFileOssAddr;
	}
	public void setFinalFileOssAddr(String finalFileOssAddr) {
		this.finalFileOssAddr = finalFileOssAddr;
	}

	public String getSealRequestId() {
		return this.sealRequestId;
	}
	public void setSealRequestId(String sealRequestId) {
		this.sealRequestId = sealRequestId;
	}

	public Date getSignedTime() {
		return this.signedTime;
	}
	public void setSignedTime(Date signedTime) {
		this.signedTime = signedTime;
	}

	public Boolean getStatus() {
		return this.status;
	}
	public void setStatus(Boolean status) {
		this.status = status;
	}

}
