package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 联营-报名-已报名记录
 *
 * @author auto create
 * @since 1.0, 2023-04-18 15:57:59
 */
public class BsEnrolledRecord extends AlipayObject {

	private static final long serialVersionUID = 3568378158978752442L;

	/**
	 * 报名基础信息
	 */
	@ApiField("enroll")
	private BsEnrollInfo enroll;

	/**
	 * 联营计划信息
	 */
	@ApiField("plan_detail")
	private BsBrandPlanDetail planDetail;

	/**
	 * 计划下的权益信息
	 */
	@ApiListField("supply_info_list")
	@ApiField("bs_supply_info")
	private List<BsSupplyInfo> supplyInfoList;

	public BsEnrollInfo getEnroll() {
		return this.enroll;
	}
	public void setEnroll(BsEnrollInfo enroll) {
		this.enroll = enroll;
	}

	public BsBrandPlanDetail getPlanDetail() {
		return this.planDetail;
	}
	public void setPlanDetail(BsBrandPlanDetail planDetail) {
		this.planDetail = planDetail;
	}

	public List<BsSupplyInfo> getSupplyInfoList() {
		return this.supplyInfoList;
	}
	public void setSupplyInfoList(List<BsSupplyInfo> supplyInfoList) {
		this.supplyInfoList = supplyInfoList;
	}

}
