package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 区块链 - 签约方详情
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:11:44
 */
public class BlockChainSignRelaDTO extends AlipayObject {

	private static final long serialVersionUID = 4682939789919355982L;

	/**
	 * 签署公司支付宝账号
	 */
	@ApiField("corp_alipay_account")
	private String corpAlipayAccount;

	/**
	 * 签署方公司编号
	 */
	@ApiField("corp_code")
	private String corpCode;

	/**
	 * 签署方公司名称
	 */
	@ApiField("corp_name")
	private String corpName;

	/**
	 * 签署方通知邮箱
	 */
	@ApiField("corp_notify_email")
	private String corpNotifyEmail;

	/**
	 * 公司类型：MAIN:蚂蚁集团 RELA:其他公司
	 */
	@ApiField("corp_type")
	private String corpType;

	/**
	 * 本签署方签约节点信息
	 */
	@ApiField("sign_node_dto")
	private BlockChainSignNodeDTO signNodeDto;

	public String getCorpAlipayAccount() {
		return this.corpAlipayAccount;
	}
	public void setCorpAlipayAccount(String corpAlipayAccount) {
		this.corpAlipayAccount = corpAlipayAccount;
	}

	public String getCorpCode() {
		return this.corpCode;
	}
	public void setCorpCode(String corpCode) {
		this.corpCode = corpCode;
	}

	public String getCorpName() {
		return this.corpName;
	}
	public void setCorpName(String corpName) {
		this.corpName = corpName;
	}

	public String getCorpNotifyEmail() {
		return this.corpNotifyEmail;
	}
	public void setCorpNotifyEmail(String corpNotifyEmail) {
		this.corpNotifyEmail = corpNotifyEmail;
	}

	public String getCorpType() {
		return this.corpType;
	}
	public void setCorpType(String corpType) {
		this.corpType = corpType;
	}

	public BlockChainSignNodeDTO getSignNodeDto() {
		return this.signNodeDto;
	}
	public void setSignNodeDto(BlockChainSignNodeDTO signNodeDto) {
		this.signNodeDto = signNodeDto;
	}

}
