package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 区块链本签署方签约节点信息
 *
 * @author auto create
 * @since 1.0, 2023-03-23 13:52:06
 */
public class BlockChainSignNodeDTO extends AlipayObject {

	private static final long serialVersionUID = 7125968319151361171L;

	/**
	 * 创建时间
	 */
	@ApiField("create_time_str")
	private Date createTimeStr;

	/**
	 * 摘要信息原文
	 */
	@ApiField("digest_data")
	private String digestData;

	/**
	 * 上一步签约操作的哈希值
	 */
	@ApiField("last_tx_hash_code")
	private String lastTxHashCode;

	/**
	 * 我方公司名称
	 */
	@ApiField("main_corp_name")
	private String mainCorpName;

	/**
	 * 上链操作记录中的流程节点主键ID（可能为空）
	 */
	@ApiField("node_id")
	private String nodeId;

	/**
	 * 节点类型（MAIN: 我方公司；PARTNER: 对方公司)
	 */
	@ApiField("node_type")
	private String nodeType;

	/**
	 * 上链信息内容
	 */
	@ApiField("notary_content")
	private String notaryContent;

	/**
	 * 上链信息摘要描述
	 */
	@ApiField("notary_data")
	private String notaryData;

	/**
	 * 状态
	 */
	@ApiField("opr_status")
	private String oprStatus;

	/**
	 * 对方公司名称
	 */
	@ApiField("rela_corp_name")
	private String relaCorpName;

	/**
	 * 业务存证状态
	 */
	@ApiField("sign_status")
	private String signStatus;

	/**
	 * 操作类型
	 */
	@ApiField("sub_sign_type")
	private String subSignType;

	/**
	 * 本次签约操作的哈希值
	 */
	@ApiField("tx_hash_code")
	private String txHashCode;

	public Date getCreateTimeStr() {
		return this.createTimeStr;
	}
	public void setCreateTimeStr(Date createTimeStr) {
		this.createTimeStr = createTimeStr;
	}

	public String getDigestData() {
		return this.digestData;
	}
	public void setDigestData(String digestData) {
		this.digestData = digestData;
	}

	public String getLastTxHashCode() {
		return this.lastTxHashCode;
	}
	public void setLastTxHashCode(String lastTxHashCode) {
		this.lastTxHashCode = lastTxHashCode;
	}

	public String getMainCorpName() {
		return this.mainCorpName;
	}
	public void setMainCorpName(String mainCorpName) {
		this.mainCorpName = mainCorpName;
	}

	public String getNodeId() {
		return this.nodeId;
	}
	public void setNodeId(String nodeId) {
		this.nodeId = nodeId;
	}

	public String getNodeType() {
		return this.nodeType;
	}
	public void setNodeType(String nodeType) {
		this.nodeType = nodeType;
	}

	public String getNotaryContent() {
		return this.notaryContent;
	}
	public void setNotaryContent(String notaryContent) {
		this.notaryContent = notaryContent;
	}

	public String getNotaryData() {
		return this.notaryData;
	}
	public void setNotaryData(String notaryData) {
		this.notaryData = notaryData;
	}

	public String getOprStatus() {
		return this.oprStatus;
	}
	public void setOprStatus(String oprStatus) {
		this.oprStatus = oprStatus;
	}

	public String getRelaCorpName() {
		return this.relaCorpName;
	}
	public void setRelaCorpName(String relaCorpName) {
		this.relaCorpName = relaCorpName;
	}

	public String getSignStatus() {
		return this.signStatus;
	}
	public void setSignStatus(String signStatus) {
		this.signStatus = signStatus;
	}

	public String getSubSignType() {
		return this.subSignType;
	}
	public void setSubSignType(String subSignType) {
		this.subSignType = subSignType;
	}

	public String getTxHashCode() {
		return this.txHashCode;
	}
	public void setTxHashCode(String txHashCode) {
		this.txHashCode = txHashCode;
	}

}
