package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 清单信息
 *
 * @author auto create
 * @since 1.0, 2023-07-06 00:05:51
 */
public class BillableInfoDetailDto extends AlipayObject {

	private static final long serialVersionUID = 3147598759165211738L;

	/**
	 * amount
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 清单描述
	 */
	@ApiField("billable_desc")
	private String billableDesc;

	/**
	 * 清单编号
	 */
	@ApiField("billable_no")
	private String billableNo;

	/**
	 * 清单类别
	 */
	@ApiField("billable_type")
	private String billableType;

	/**
	 * 币种编码
	 */
	@ApiField("currency_code")
	private String currencyCode;

	/**
	 * 收到金额
	 */
	@ApiField("entry_amount")
	private String entryAmount;

	/**
	 * 发票类型
	 */
	@ApiField("invoice_type")
	private String invoiceType;

	/**
	 * 发票信息
	 */
	@ApiListField("invoices")
	@ApiField("invoice_d_t_o")
	private List<InvoiceDTO> invoices;

	/**
	 * 组织id
	 */
	@ApiField("org_id")
	private Long orgId;

	/**
	 * 组织名称
	 */
	@ApiField("org_name")
	private String orgName;

	/**
	 * precision
	 */
	@ApiField("precision")
	private Long precision;

	/**
	 * 税务信息
	 */
	@ApiField("tax_info_dto")
	private TaxInfoDto taxInfoDto;

	/**
	 * 税利率
	 */
	@ApiField("tax_rate")
	private String taxRate;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getBillableDesc() {
		return this.billableDesc;
	}
	public void setBillableDesc(String billableDesc) {
		this.billableDesc = billableDesc;
	}

	public String getBillableNo() {
		return this.billableNo;
	}
	public void setBillableNo(String billableNo) {
		this.billableNo = billableNo;
	}

	public String getBillableType() {
		return this.billableType;
	}
	public void setBillableType(String billableType) {
		this.billableType = billableType;
	}

	public String getCurrencyCode() {
		return this.currencyCode;
	}
	public void setCurrencyCode(String currencyCode) {
		this.currencyCode = currencyCode;
	}

	public String getEntryAmount() {
		return this.entryAmount;
	}
	public void setEntryAmount(String entryAmount) {
		this.entryAmount = entryAmount;
	}

	public String getInvoiceType() {
		return this.invoiceType;
	}
	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public List<InvoiceDTO> getInvoices() {
		return this.invoices;
	}
	public void setInvoices(List<InvoiceDTO> invoices) {
		this.invoices = invoices;
	}

	public Long getOrgId() {
		return this.orgId;
	}
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return this.orgName;
	}
	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getPrecision() {
		return this.precision;
	}
	public void setPrecision(Long precision) {
		this.precision = precision;
	}

	public TaxInfoDto getTaxInfoDto() {
		return this.taxInfoDto;
	}
	public void setTaxInfoDto(TaxInfoDto taxInfoDto) {
		this.taxInfoDto = taxInfoDto;
	}

	public String getTaxRate() {
		return this.taxRate;
	}
	public void setTaxRate(String taxRate) {
		this.taxRate = taxRate;
	}

}
