package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 应付月账单确认记录
 *
 * @author auto create
 * @since 1.0, 2019-12-10 17:59:34
 */
public class ApMonthlyBillChkRecordOpenApiResponse extends AlipayObject {

	private static final long serialVersionUID = 1713455947219759279L;

	/**
	 * 调整摘要
	 */
	@ApiField("adj_memo")
	private String adjMemo;

	/**
	 * 汇总调整账单金额，仅供内部用户查询使用字段
	 */
	@ApiField("agr_adj_bill_amt")
	private MultiCurrencyMoneyOpenApi agrAdjBillAmt;

	/**
	 * 合约号
	 */
	@ApiField("ar_no")
	private String arNo;

	/**
	 * 原始账单金额，仅供内部用户查询使用字段
	 */
	@ApiField("bill_amt")
	private MultiCurrencyMoneyOpenApi billAmt;

	/**
	 * 账单号
	 */
	@ApiField("bill_no")
	private String billNo;

	/**
	 * 确认时间（ms）
	 */
	@ApiField("chk_date")
	private Date chkDate;

	/**
	 * 确认记录号
	 */
	@ApiField("chk_record_no")
	private String chkRecordNo;

	/**
	 * 确认类型{"01":"内部对账","02":"自动确认","03":"无据支出调账确认"}
	 */
	@ApiField("chk_type")
	private String chkType;

	/**
	 * 明细调整账单金额，仅供内部用户查询使用字段
	 */
	@ApiField("dtl_adj_bill_amt")
	private MultiCurrencyMoneyOpenApi dtlAdjBillAmt;

	/**
	 * 明细文件信息，形如{k1:'v1', k2:'v2'}
	 */
	@ApiField("dtl_file_info")
	private String dtlFileInfo;

	/**
	 * 止付金额，客户和内部用户查询使用字段
	 */
	@ApiField("fbd_pay_amt")
	private MultiCurrencyMoneyOpenApi fbdPayAmt;

	/**
	 * 止付类型{"01":"客户级别止付","02":"用户级别止付","03":"账单级别止付","04":"用户产品级别止付","05":"客户产品级别止付","99":"未止付"}
	 */
	@ApiField("fbd_pay_type")
	private String fbdPayType;

	/**
	 * 分支机构ID（OU标识）
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 结算对象（PID）
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 签约对象MID（非商户时为空）
	 */
	@ApiField("mid")
	private String mid;

	/**
	 * 已付金额
	 */
	@ApiField("paid_amt")
	private MultiCurrencyMoneyOpenApi paidAmt;

	/**
	 * 付款状态[01-待结算；02-部分结算；03-结算完成]
	 */
	@ApiField("pay_status")
	private String payStatus;

	/**
	 * 产品码
	 */
	@ApiField("pd_code")
	private String pdCode;

	/**
	 * 产品名称
	 */
	@ApiField("pd_name")
	private String pdName;

	/**
	 * 账单金额，客户和内部用户查询使用字段
	 */
	@ApiField("real_bill_amt")
	private MultiCurrencyMoneyOpenApi realBillAmt;

	/**
	 * 审批工单号
	 */
	@ApiField("work_flow_no")
	private String workFlowNo;

	public String getAdjMemo() {
		return this.adjMemo;
	}
	public void setAdjMemo(String adjMemo) {
		this.adjMemo = adjMemo;
	}

	public MultiCurrencyMoneyOpenApi getAgrAdjBillAmt() {
		return this.agrAdjBillAmt;
	}
	public void setAgrAdjBillAmt(MultiCurrencyMoneyOpenApi agrAdjBillAmt) {
		this.agrAdjBillAmt = agrAdjBillAmt;
	}

	public String getArNo() {
		return this.arNo;
	}
	public void setArNo(String arNo) {
		this.arNo = arNo;
	}

	public MultiCurrencyMoneyOpenApi getBillAmt() {
		return this.billAmt;
	}
	public void setBillAmt(MultiCurrencyMoneyOpenApi billAmt) {
		this.billAmt = billAmt;
	}

	public String getBillNo() {
		return this.billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}

	public Date getChkDate() {
		return this.chkDate;
	}
	public void setChkDate(Date chkDate) {
		this.chkDate = chkDate;
	}

	public String getChkRecordNo() {
		return this.chkRecordNo;
	}
	public void setChkRecordNo(String chkRecordNo) {
		this.chkRecordNo = chkRecordNo;
	}

	public String getChkType() {
		return this.chkType;
	}
	public void setChkType(String chkType) {
		this.chkType = chkType;
	}

	public MultiCurrencyMoneyOpenApi getDtlAdjBillAmt() {
		return this.dtlAdjBillAmt;
	}
	public void setDtlAdjBillAmt(MultiCurrencyMoneyOpenApi dtlAdjBillAmt) {
		this.dtlAdjBillAmt = dtlAdjBillAmt;
	}

	public String getDtlFileInfo() {
		return this.dtlFileInfo;
	}
	public void setDtlFileInfo(String dtlFileInfo) {
		this.dtlFileInfo = dtlFileInfo;
	}

	public MultiCurrencyMoneyOpenApi getFbdPayAmt() {
		return this.fbdPayAmt;
	}
	public void setFbdPayAmt(MultiCurrencyMoneyOpenApi fbdPayAmt) {
		this.fbdPayAmt = fbdPayAmt;
	}

	public String getFbdPayType() {
		return this.fbdPayType;
	}
	public void setFbdPayType(String fbdPayType) {
		this.fbdPayType = fbdPayType;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public String getMid() {
		return this.mid;
	}
	public void setMid(String mid) {
		this.mid = mid;
	}

	public MultiCurrencyMoneyOpenApi getPaidAmt() {
		return this.paidAmt;
	}
	public void setPaidAmt(MultiCurrencyMoneyOpenApi paidAmt) {
		this.paidAmt = paidAmt;
	}

	public String getPayStatus() {
		return this.payStatus;
	}
	public void setPayStatus(String payStatus) {
		this.payStatus = payStatus;
	}

	public String getPdCode() {
		return this.pdCode;
	}
	public void setPdCode(String pdCode) {
		this.pdCode = pdCode;
	}

	public String getPdName() {
		return this.pdName;
	}
	public void setPdName(String pdName) {
		this.pdName = pdName;
	}

	public MultiCurrencyMoneyOpenApi getRealBillAmt() {
		return this.realBillAmt;
	}
	public void setRealBillAmt(MultiCurrencyMoneyOpenApi realBillAmt) {
		this.realBillAmt = realBillAmt;
	}

	public String getWorkFlowNo() {
		return this.workFlowNo;
	}
	public void setWorkFlowNo(String workFlowNo) {
		this.workFlowNo = workFlowNo;
	}

}
