package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 区块链B2B资金服务交易分账
 *
 * @author auto create
 * @since 1.0, 2023-03-02 19:02:45
 */
public class AnttechBlockchainDefinSaasPaymentShareModel extends AlipayObject {

	private static final long serialVersionUID = 6872592697513895888L;

	/**
	 * 外部业务平台原始交易号
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/**
	 * 付款方外部业务平台会员ID
	 */
	@ApiField("out_payer_id")
	private ReferenceId outPayerId;

	/**
	 * 外部请求ID
	 */
	@ApiField("out_request_id")
	private String outRequestId;

	/**
	 * 会员所属业务平台在智能科技的会员ID
	 */
	@ApiField("platform_member_id")
	private String platformMemberId;

	/**
	 * 分账信息数组
	 */
	@ApiListField("share_info")
	@ApiField("pay_share_v_o")
	private List<PayShareVO> shareInfo;

	public String getOutOrderId() {
		return this.outOrderId;
	}
	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public ReferenceId getOutPayerId() {
		return this.outPayerId;
	}
	public void setOutPayerId(ReferenceId outPayerId) {
		this.outPayerId = outPayerId;
	}

	public String getOutRequestId() {
		return this.outRequestId;
	}
	public void setOutRequestId(String outRequestId) {
		this.outRequestId = outRequestId;
	}

	public String getPlatformMemberId() {
		return this.platformMemberId;
	}
	public void setPlatformMemberId(String platformMemberId) {
		this.platformMemberId = platformMemberId;
	}

	public List<PayShareVO> getShareInfo() {
		return this.shareInfo;
	}
	public void setShareInfo(List<PayShareVO> shareInfo) {
		this.shareInfo = shareInfo;
	}

}
