package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 区块链B2B资金服务交易支付
 *
 * @author auto create
 * @since 1.0, 2023-03-14 21:04:37
 */
public class AnttechBlockchainDefinSaasPaymentPayModel extends AlipayObject {

	private static final long serialVersionUID = 6522776354879817248L;

	/**
	 * 支付时间
	 */
	@ApiField("order_pay_time")
	private Date orderPayTime;

	/**
	 * 外部业务平台原始交易号
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/**
	 * 付款方外部业务平台会员ID
	 */
	@ApiField("out_payer_id")
	private ReferenceId outPayerId;

	/**
	 * 外部请求ID，不支持多次付款时需填out_order_id
	 */
	@ApiField("out_request_id")
	private String outRequestId;

	/**
	 * 收款账号
	 */
	@ApiField("payee_account")
	private AccountDTO payeeAccount;

	/**
	 * 付款金额明细
	 */
	@ApiListField("payer_details")
	@ApiField("payer_detail_v_o")
	private List<PayerDetailVO> payerDetails;

	/**
	 * 会员所属业务平台在智能科技的会员ID
	 */
	@ApiField("platform_member_id")
	private String platformMemberId;

	public Date getOrderPayTime() {
		return this.orderPayTime;
	}
	public void setOrderPayTime(Date orderPayTime) {
		this.orderPayTime = orderPayTime;
	}

	public String getOutOrderId() {
		return this.outOrderId;
	}
	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public ReferenceId getOutPayerId() {
		return this.outPayerId;
	}
	public void setOutPayerId(ReferenceId outPayerId) {
		this.outPayerId = outPayerId;
	}

	public String getOutRequestId() {
		return this.outRequestId;
	}
	public void setOutRequestId(String outRequestId) {
		this.outRequestId = outRequestId;
	}

	public AccountDTO getPayeeAccount() {
		return this.payeeAccount;
	}
	public void setPayeeAccount(AccountDTO payeeAccount) {
		this.payeeAccount = payeeAccount;
	}

	public List<PayerDetailVO> getPayerDetails() {
		return this.payerDetails;
	}
	public void setPayerDetails(List<PayerDetailVO> payerDetails) {
		this.payerDetails = payerDetails;
	}

	public String getPlatformMemberId() {
		return this.platformMemberId;
	}
	public void setPlatformMemberId(String platformMemberId) {
		this.platformMemberId = platformMemberId;
	}

}
