package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 成交数据回报
 *
 * @author auto create
 * @since 1.0, 2020-09-23 14:28:40
 */
public class AntfortuneStockDealStatisticSyncModel extends AlipayObject {

	private static final long serialVersionUID = 5242537691128397427L;

	/**
	 * 绑定用户统计，是个List类型，List元素类型为ChannelDealStatistic
	 */
	@ApiListField("bind_user_deals_list")
	@ApiField("channel_deal_statistic")
	private List<ChannelDealStatistic> bindUserDealsList;

	/**
	 * 蚂蚁标记各家券商的一个Id标识
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 导流开户用户统计，是个List类型，List元素的类型为ChannelDealStatistic
	 */
	@ApiListField("open_user_deals_list")
	@ApiField("channel_deal_statistic")
	private List<ChannelDealStatistic> openUserDealsList;

	/**
	 * 统计截止时间
	 */
	@ApiField("statistic_end")
	private Date statisticEnd;

	/**
	 * 统计起始时间
	 */
	@ApiField("statistic_start")
	private Date statisticStart;

	public List<ChannelDealStatistic> getBindUserDealsList() {
		return this.bindUserDealsList;
	}
	public void setBindUserDealsList(List<ChannelDealStatistic> bindUserDealsList) {
		this.bindUserDealsList = bindUserDealsList;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public List<ChannelDealStatistic> getOpenUserDealsList() {
		return this.openUserDealsList;
	}
	public void setOpenUserDealsList(List<ChannelDealStatistic> openUserDealsList) {
		this.openUserDealsList = openUserDealsList;
	}

	public Date getStatisticEnd() {
		return this.statisticEnd;
	}
	public void setStatisticEnd(Date statisticEnd) {
		this.statisticEnd = statisticEnd;
	}

	public Date getStatisticStart() {
		return this.statisticStart;
	}
	public void setStatisticStart(Date statisticStart) {
		this.statisticStart = statisticStart;
	}

}
