package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 批量查询人员信息
 *
 * @author auto create
 * @since 1.0, 2022-12-22 19:11:27
 */
public class AntProdpaasProductInfoDetailBatchqueryModel extends AlipayObject {

	private static final long serialVersionUID = 4738154711847159764L;

	/**
	 * 参数名：gateway_aone_id
应用场景：业务系统需要记录消费方的应用aone id
如何获取：aone平台应用详情页面获取
	 */
	@ApiField("gate_way_aone_id")
	private String gateWayAoneId;

	/**
	 * 参数名：gateway_aone_name
应用场景：业务系统需要记录消费方系统名称
如何获取：根据实际消费方系统名称传入即可
	 */
	@ApiField("gate_way_aone_name")
	private String gateWayAoneName;

	/**
	 * 参数名：gate_way_app_access_key
应用场景：业务系统需要根据请求方提供的密钥进行接口鉴权
如何获取：蚂蚁epass平台注册应用查看
	 */
	@ApiField("gate_way_app_access_key")
	private String gateWayAppAccessKey;

	/**
	 * 参数名：gate_way_remote_ip
应用场景：业务系统需要记录消费方的机器ip
如何获取：请消费方根据实际调用机器ip传入即可
	 */
	@ApiField("gate_way_remote_ip")
	private String gateWayRemoteIp;

	/**
	 * 参数名：gate_way_self_access_key
应用场景：业务系统需要根据消费方的私钥进行接口鉴权
	 */
	@ApiField("gate_way_self_access_key")
	private String gateWaySelfAccessKey;

	/**
	 * 参数名：login_user_id
应用场景：接口获取当前登陆人工号
如何获取：调用方按实际登陆人传入
	 */
	@ApiField("login_user_id")
	private Long loginUserId;

	/**
	 * 参数名：login_user_language
应用场景：部分接口会根据登陆人语言状态选择是否返回国际化数据
如何获取：调用方根据登陆人语言状态传入即可（如有）
	 */
	@ApiField("login_user_language")
	private String loginUserLanguage;

	/**
	 * 参数名：login_work_no
应用场景：接口需要获取当前登陆人工号
如何获取：调用方根据操作人实际工号传入即可
	 */
	@ApiField("login_work_no")
	private String loginWorkNo;

	/**
	 * 参数名：work_nos
应用场景：消费方传递目标查询参数，业务系统查询
如何获取：消费方根据自身需要填写所需查询工号即可
	 */
	@ApiField("work_nos")
	private String workNos;

	public String getGateWayAoneId() {
		return this.gateWayAoneId;
	}
	public void setGateWayAoneId(String gateWayAoneId) {
		this.gateWayAoneId = gateWayAoneId;
	}

	public String getGateWayAoneName() {
		return this.gateWayAoneName;
	}
	public void setGateWayAoneName(String gateWayAoneName) {
		this.gateWayAoneName = gateWayAoneName;
	}

	public String getGateWayAppAccessKey() {
		return this.gateWayAppAccessKey;
	}
	public void setGateWayAppAccessKey(String gateWayAppAccessKey) {
		this.gateWayAppAccessKey = gateWayAppAccessKey;
	}

	public String getGateWayRemoteIp() {
		return this.gateWayRemoteIp;
	}
	public void setGateWayRemoteIp(String gateWayRemoteIp) {
		this.gateWayRemoteIp = gateWayRemoteIp;
	}

	public String getGateWaySelfAccessKey() {
		return this.gateWaySelfAccessKey;
	}
	public void setGateWaySelfAccessKey(String gateWaySelfAccessKey) {
		this.gateWaySelfAccessKey = gateWaySelfAccessKey;
	}

	public Long getLoginUserId() {
		return this.loginUserId;
	}
	public void setLoginUserId(Long loginUserId) {
		this.loginUserId = loginUserId;
	}

	public String getLoginUserLanguage() {
		return this.loginUserLanguage;
	}
	public void setLoginUserLanguage(String loginUserLanguage) {
		this.loginUserLanguage = loginUserLanguage;
	}

	public String getLoginWorkNo() {
		return this.loginWorkNo;
	}
	public void setLoginWorkNo(String loginWorkNo) {
		this.loginWorkNo = loginWorkNo;
	}

	public String getWorkNos() {
		return this.workNos;
	}
	public void setWorkNos(String workNos) {
		this.workNos = workNos;
	}

}
