package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * docusign签约组件信息
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:11:14
 */
public class AlsacenterSignerAndTabVosDTO extends AlipayObject {

	private static final long serialVersionUID = 5241532176528417454L;

	/**
	 * 签约顺序 1~10 不同的人请保持不一致
	 */
	@ApiField("order")
	private Long order;

	/**
	 * 区分内部外部人员，默认内部
	 */
	@ApiField("side")
	private String side;

	/**
	 * 签署人邮箱 (外部)
	 */
	@ApiField("signer_email")
	private String signerEmail;

	/**
	 * 签署人工号（内部）
	 */
	@ApiField("signer_num")
	private String signerNum;

	/**
	 * 签署组件信息集合
	 */
	@ApiListField("tabs_list")
	@ApiField("alsacenter_seal_tabs_d_t_o")
	private List<AlsacenterSealTabsDTO> tabsList;

	public Long getOrder() {
		return this.order;
	}
	public void setOrder(Long order) {
		this.order = order;
	}

	public String getSide() {
		return this.side;
	}
	public void setSide(String side) {
		this.side = side;
	}

	public String getSignerEmail() {
		return this.signerEmail;
	}
	public void setSignerEmail(String signerEmail) {
		this.signerEmail = signerEmail;
	}

	public String getSignerNum() {
		return this.signerNum;
	}
	public void setSignerNum(String signerNum) {
		this.signerNum = signerNum;
	}

	public List<AlsacenterSealTabsDTO> getTabsList() {
		return this.tabsList;
	}
	public void setTabsList(List<AlsacenterSealTabsDTO> tabsList) {
		this.tabsList = tabsList;
	}

}
