package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 签署方信息实体
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:09:59
 */
public class AlsacenterSignOperatorDTO extends AlipayObject {

	private static final long serialVersionUID = 4452342787442356116L;

	/**
	 * 支付宝账号
	 */
	@ApiField("alipay_account")
	private String alipayAccount;

	/**
	 * 公司OuCode
	 */
	@ApiField("company_ou_code")
	private String companyOuCode;

	/**
	 * 公司编码类型
	 */
	@ApiField("corp_type")
	private String corpType;

	/**
	 * 国家
	 */
	@ApiField("country")
	private String country;

	/**
	 * 签约机构企业证件号或签约个人身份证号
	 */
	@ApiField("operator_cert_no")
	private String operatorCertNo;

	/**
	 * 签约机构或签约个人名称
	 */
	@ApiField("operator_en_name")
	private String operatorEnName;

	/**
	 * 公司库对应实体ID
	 */
	@ApiField("operator_entity_id")
	private String operatorEntityId;

	/**
	 * 签约机构或签约个人名称
	 */
	@ApiField("operator_name")
	private String operatorName;

	/**
	 * 签约人类型 PERSON:个人 ENTERPRISE：企业
	 */
	@ApiField("operator_type")
	private String operatorType;

	/**
	 * 签约人支付宝uid
	 */
	@ApiField("operator_uid")
	private String operatorUid;

	/**
	 * 个人编码类型（当operatorType=PERSONAL时，不能为空）
	 */
	@ApiField("personal_type")
	private String personalType;

	/**
	 * 签约方，OUR_SIDE：我方 ，OTHER_SIDE：对方
	 */
	@ApiField("sign_side_type")
	private String signSideType;

	/**
	 * 外部签署人邮箱
	 */
	@ApiField("signer_email")
	private String signerEmail;

	/**
	 * 外部签署人手机号
	 */
	@ApiField("signer_mobile")
	private String signerMobile;

	public String getAlipayAccount() {
		return this.alipayAccount;
	}
	public void setAlipayAccount(String alipayAccount) {
		this.alipayAccount = alipayAccount;
	}

	public String getCompanyOuCode() {
		return this.companyOuCode;
	}
	public void setCompanyOuCode(String companyOuCode) {
		this.companyOuCode = companyOuCode;
	}

	public String getCorpType() {
		return this.corpType;
	}
	public void setCorpType(String corpType) {
		this.corpType = corpType;
	}

	public String getCountry() {
		return this.country;
	}
	public void setCountry(String country) {
		this.country = country;
	}

	public String getOperatorCertNo() {
		return this.operatorCertNo;
	}
	public void setOperatorCertNo(String operatorCertNo) {
		this.operatorCertNo = operatorCertNo;
	}

	public String getOperatorEnName() {
		return this.operatorEnName;
	}
	public void setOperatorEnName(String operatorEnName) {
		this.operatorEnName = operatorEnName;
	}

	public String getOperatorEntityId() {
		return this.operatorEntityId;
	}
	public void setOperatorEntityId(String operatorEntityId) {
		this.operatorEntityId = operatorEntityId;
	}

	public String getOperatorName() {
		return this.operatorName;
	}
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public String getOperatorType() {
		return this.operatorType;
	}
	public void setOperatorType(String operatorType) {
		this.operatorType = operatorType;
	}

	public String getOperatorUid() {
		return this.operatorUid;
	}
	public void setOperatorUid(String operatorUid) {
		this.operatorUid = operatorUid;
	}

	public String getPersonalType() {
		return this.personalType;
	}
	public void setPersonalType(String personalType) {
		this.personalType = personalType;
	}

	public String getSignSideType() {
		return this.signSideType;
	}
	public void setSignSideType(String signSideType) {
		this.signSideType = signSideType;
	}

	public String getSignerEmail() {
		return this.signerEmail;
	}
	public void setSignerEmail(String signerEmail) {
		this.signerEmail = signerEmail;
	}

	public String getSignerMobile() {
		return this.signerMobile;
	}
	public void setSignerMobile(String signerMobile) {
		this.signerMobile = signerMobile;
	}

}
