package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * ca签名实体
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:12:01
 */
public class AlsacenterSignOperator extends AlipayObject {

	private static final long serialVersionUID = 6465633139854833351L;

	/**
	 * 签约人证件类型 
    IDENTIFY("IDENTIFY", "身份证号"),
    BRNUMBER("BRNUMBER", "工商注册号"),
    USCC("USCC", "统一社会信用代码");
	 */
	@ApiField("cert_type")
	private String certType;

	/**
	 * 签约机构企业证件号或签约个人身份证号
	 */
	@ApiField("operator_cert_no")
	private String operatorCertNo;

	/**
	 * 签约机构或签约个人名称
	 */
	@ApiField("operator_name")
	private String operatorName;

	/**
	 * 签约人类型,
    PERSON("individual", "个人"),
    ENTERPRISE("enterprise", "企业");
	 */
	@ApiField("operator_type")
	private String operatorType;

	/**
	 * 签约人支付宝uid
	 */
	@ApiField("operator_uid")
	private String operatorUid;

	/**
	 * 签约方
    OUR_SIDE("OUR_SIDE", "我方"),
    OTHER_SIDE("OTHER_SIDE", "对方"),
	 */
	@ApiField("sign_side_type")
	private String signSideType;

	public String getCertType() {
		return this.certType;
	}
	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getOperatorCertNo() {
		return this.operatorCertNo;
	}
	public void setOperatorCertNo(String operatorCertNo) {
		this.operatorCertNo = operatorCertNo;
	}

	public String getOperatorName() {
		return this.operatorName;
	}
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public String getOperatorType() {
		return this.operatorType;
	}
	public void setOperatorType(String operatorType) {
		this.operatorType = operatorType;
	}

	public String getOperatorUid() {
		return this.operatorUid;
	}
	public void setOperatorUid(String operatorUid) {
		this.operatorUid = operatorUid;
	}

	public String getSignSideType() {
		return this.signSideType;
	}
	public void setSignSideType(String signSideType) {
		this.signSideType = signSideType;
	}

}
