package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 签署组件信息
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:10:58
 */
public class AlsacenterSealTabsDTO extends AlipayObject {

	private static final long serialVersionUID = 5771993677175149368L;

	/**
	 * fileId关联标注哪一个文件
	 */
	@ApiField("file_id")
	private String fileId;

	/**
	 * 签署位置关键字 关键字模式必传
	 */
	@ApiField("keyword")
	private String keyword;

	/**
	 * 签署关键字索引，默认第【pageNumber】页 第【kwIndex】个关键字
	 */
	@ApiField("kw_index")
	private Long kwIndex;

	/**
	 * 页码
	 */
	@ApiField("page_number")
	private Long pageNumber;

	/**
	 * 签署人位置识别类型：关键字签字||绝对坐标签字@see SealModeEnum.

   KEY_WORD("KEY_WORD", "关键字模式"),
    ABSOLUTE_POSITION("ABSOLUTE_POSITION", "绝对坐标模式");
	 */
	@ApiField("seal_type")
	private String sealType;

	/**
	 * 签署组件类型@see DocusignSealTabsEnum
    signHereTabs("signHereTabs", "签名位置"),
    dateSignedTabs("dateSignedTabs", "签署日期"),
    textTabs("textTabs", "空白字符");
	 */
	@ApiField("tab_type")
	private String tabType;

	/**
	 * 坐标用印x轴位置
	 */
	@ApiField("x_position")
	private Long xPosition;

	/**
	 * 坐标用印y轴位置
	 */
	@ApiField("y_position")
	private Long yPosition;

	public String getFileId() {
		return this.fileId;
	}
	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getKeyword() {
		return this.keyword;
	}
	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public Long getKwIndex() {
		return this.kwIndex;
	}
	public void setKwIndex(Long kwIndex) {
		this.kwIndex = kwIndex;
	}

	public Long getPageNumber() {
		return this.pageNumber;
	}
	public void setPageNumber(Long pageNumber) {
		this.pageNumber = pageNumber;
	}

	public String getSealType() {
		return this.sealType;
	}
	public void setSealType(String sealType) {
		this.sealType = sealType;
	}

	public String getTabType() {
		return this.tabType;
	}
	public void setTabType(String tabType) {
		this.tabType = tabType;
	}

	public Long getxPosition() {
		return this.xPosition;
	}
	public void setxPosition(Long xPosition) {
		this.xPosition = xPosition;
	}

	public Long getyPosition() {
		return this.yPosition;
	}
	public void setyPosition(Long yPosition) {
		this.yPosition = yPosition;
	}

}
