package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 固定绝对坐标
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:12:30
 */
public class AlsacenterSealRequestInfo extends AlipayObject {

	private static final long serialVersionUID = 8615473654441866288L;

	/**
	 * 用印位置的坐标X轴位置
	 */
	@ApiField("axis_x")
	private Long axisX;

	/**
	 * 用印位置的坐标Y轴位置
	 */
	@ApiField("axis_y")
	private Long axisY;

	/**
	 * 关键字
	 */
	@ApiField("keyword")
	private String keyword;

	/**
	 * 当传入关键字时，kwIndex 不能为空,从1开始，表示第一个命中的关键字
	 */
	@ApiField("kw_index")
	private String kwIndex;

	/**
	 * 距关键字序号keywordIndex的关键字的中心坐标X轴的偏移量
	 */
	@ApiField("kw_shift_x")
	private Long kwShiftX;

	/**
	 * 距关键字序号keywordIndex的关键字的坐标Y轴的偏移量
	 */
	@ApiField("kw_shift_y")
	private Long kwShiftY;

	/**
	 * 用印对齐类型
	 */
	@ApiField("location_type")
	private String locationType;

	/**
	 * 章的旋转角度，顺时针方向旋转，0到360度  ，默认为0
	 */
	@ApiField("rotate_angle")
	private Long rotateAngle;

	/**
	 * 印章id
	 */
	@ApiField("seal_id")
	private Long sealId;

	/**
	 * 印章id集合
	 */
	@ApiListField("seal_ids_list")
	@ApiField("number")
	private List<Long> sealIdsList;

	public Long getAxisX() {
		return this.axisX;
	}
	public void setAxisX(Long axisX) {
		this.axisX = axisX;
	}

	public Long getAxisY() {
		return this.axisY;
	}
	public void setAxisY(Long axisY) {
		this.axisY = axisY;
	}

	public String getKeyword() {
		return this.keyword;
	}
	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public String getKwIndex() {
		return this.kwIndex;
	}
	public void setKwIndex(String kwIndex) {
		this.kwIndex = kwIndex;
	}

	public Long getKwShiftX() {
		return this.kwShiftX;
	}
	public void setKwShiftX(Long kwShiftX) {
		this.kwShiftX = kwShiftX;
	}

	public Long getKwShiftY() {
		return this.kwShiftY;
	}
	public void setKwShiftY(Long kwShiftY) {
		this.kwShiftY = kwShiftY;
	}

	public String getLocationType() {
		return this.locationType;
	}
	public void setLocationType(String locationType) {
		this.locationType = locationType;
	}

	public Long getRotateAngle() {
		return this.rotateAngle;
	}
	public void setRotateAngle(Long rotateAngle) {
		this.rotateAngle = rotateAngle;
	}

	public Long getSealId() {
		return this.sealId;
	}
	public void setSealId(Long sealId) {
		this.sealId = sealId;
	}

	public List<Long> getSealIdsList() {
		return this.sealIdsList;
	}
	public void setSealIdsList(List<Long> sealIdsList) {
		this.sealIdsList = sealIdsList;
	}

}
