package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 用印坐标
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:14:01
 */
public class AlsacenterSealCoordinate extends AlipayObject {

	private static final long serialVersionUID = 6239815892823777364L;

	/**
	 * 文件编号
	 */
	@ApiField("attach_voucher_id")
	private String attachVoucherId;

	/**
	 * 高度
	 */
	@ApiField("height")
	private Long height;

	/**
	 * 页数
	 */
	@ApiField("pos_page")
	private Long posPage;

	/**
	 * x轴坐标
	 */
	@ApiField("pos_x")
	private Long posX;

	/**
	 * y轴坐标（相对左上角）
	 */
	@ApiField("pos_y")
	private Long posY;

	/**
	 * 印章ID
	 */
	@ApiField("seal_code")
	private Long sealCode;

	/**
	 * 印章名称
	 */
	@ApiField("seal_name")
	private String sealName;

	/**
	 * 印章类型
	 */
	@ApiField("seal_type")
	private String sealType;

	/**
	 * 租户
	 */
	@ApiField("tenant")
	private String tenant;

	/**
	 * 宽度
	 */
	@ApiField("width")
	private Long width;

	public String getAttachVoucherId() {
		return this.attachVoucherId;
	}
	public void setAttachVoucherId(String attachVoucherId) {
		this.attachVoucherId = attachVoucherId;
	}

	public Long getHeight() {
		return this.height;
	}
	public void setHeight(Long height) {
		this.height = height;
	}

	public Long getPosPage() {
		return this.posPage;
	}
	public void setPosPage(Long posPage) {
		this.posPage = posPage;
	}

	public Long getPosX() {
		return this.posX;
	}
	public void setPosX(Long posX) {
		this.posX = posX;
	}

	public Long getPosY() {
		return this.posY;
	}
	public void setPosY(Long posY) {
		this.posY = posY;
	}

	public Long getSealCode() {
		return this.sealCode;
	}
	public void setSealCode(Long sealCode) {
		this.sealCode = sealCode;
	}

	public String getSealName() {
		return this.sealName;
	}
	public void setSealName(String sealName) {
		this.sealName = sealName;
	}

	public String getSealType() {
		return this.sealType;
	}
	public void setSealType(String sealType) {
		this.sealType = sealType;
	}

	public String getTenant() {
		return this.tenant;
	}
	public void setTenant(String tenant) {
		this.tenant = tenant;
	}

	public Long getWidth() {
		return this.width;
	}
	public void setWidth(Long width) {
		this.width = width;
	}

}
