package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 纸质用印
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:12:45
 */
public class AlsacenterPaperSealDTO extends AlipayObject {

	private static final long serialVersionUID = 5118998687132198623L;

	/**
	 * 期望领件后多久归还
	 */
	@ApiField("delay_days")
	private Long delayDays;

	/**
	 * 交件方式("PRINT", "打印"),
("DELIVERY", "手动送件");
	 */
	@ApiField("delivery_type_enum")
	private String deliveryTypeEnum;

	/**
	 * 期望完成时间
	 */
	@ApiField("expect_finish_date")
	private Date expectFinishDate;

	/**
	 * 用印公章类型集合OFFICIAL_SEAL("OFFICIAL_SEAL", "公章"),
    LEGAL_SEAL("LEGAL_SEAL", "法人章"),
    FINANCIAL_SEAL("FINANCIAL_SEAL", "财务章"),
    OVERSEAS_OFFICIAL_SEAL("OVERSEAS_OFFICIAL_SEAL", "境外公章"),
    DIRECTOR_SIGN("DIRECTOR_SIGN", "董事签字"),
    AUTHORIZER_SIGN("AUTHORIZER_SIGN", "授权人签字"),
    BUSINESS_SEAL("BUSINESS_SEAL", "业务专用章"),
    ELEC_PRINT_SEAL("ELEC_PRINT_SEAL", "电子打印章");
	 */
	@ApiListField("imprint_types_set")
	@ApiField("string")
	private List<String> imprintTypesSet;

	/**
	 * 纸质用印方式("PHY_SEAL", "实体用印"),
("ELEC_SEAL", "电子打印章"),
("SUPPLY_PHY_SEAL", "补盖实体章");
	 */
	@ApiField("paper_sign_type_enum")
	private String paperSignTypeEnum;

	/**
	 * 领件人名称
	 */
	@ApiField("receiver_name")
	private String receiverName;

	/**
	 * 领件人工号
	 */
	@ApiField("receiver_no")
	private String receiverNo;

	/**
	 * 用印顺序    ("OUR_IMPRINT_FIRST", "我方先用印"),
("OPPOSITE_IMPRINT_FIRST", "对方先用印"),
("ONLY_OUR_IMPRINT", "只需我方用印");
	 */
	@ApiField("seal_order")
	private String sealOrder;

	/**
	 * 邮寄信息
	 */
	@ApiField("seal_postal_info_dto")
	private AlsacenterSealPostalInfoDTO sealPostalInfoDto;

	/**
	 * 送件人
	 */
	@ApiField("sender_name")
	private String senderName;

	/**
	 * 送件人工号
	 */
	@ApiField("sender_no")
	private String senderNo;

	/**
	 * <暂定>指定用章信息Map<ImprintTypeEnum, List<SealInfoDTO>>
	 */
	@ApiField("special_seal_info_map")
	private String specialSealInfoMap;

	/**
	 * 取件方式("EXPRESS", "小邮局"),
("MANUAL", "现场取件"),
("LOCKER", "自提柜");
	 */
	@ApiField("take_away_type")
	private String takeAwayType;

	public Long getDelayDays() {
		return this.delayDays;
	}
	public void setDelayDays(Long delayDays) {
		this.delayDays = delayDays;
	}

	public String getDeliveryTypeEnum() {
		return this.deliveryTypeEnum;
	}
	public void setDeliveryTypeEnum(String deliveryTypeEnum) {
		this.deliveryTypeEnum = deliveryTypeEnum;
	}

	public Date getExpectFinishDate() {
		return this.expectFinishDate;
	}
	public void setExpectFinishDate(Date expectFinishDate) {
		this.expectFinishDate = expectFinishDate;
	}

	public List<String> getImprintTypesSet() {
		return this.imprintTypesSet;
	}
	public void setImprintTypesSet(List<String> imprintTypesSet) {
		this.imprintTypesSet = imprintTypesSet;
	}

	public String getPaperSignTypeEnum() {
		return this.paperSignTypeEnum;
	}
	public void setPaperSignTypeEnum(String paperSignTypeEnum) {
		this.paperSignTypeEnum = paperSignTypeEnum;
	}

	public String getReceiverName() {
		return this.receiverName;
	}
	public void setReceiverName(String receiverName) {
		this.receiverName = receiverName;
	}

	public String getReceiverNo() {
		return this.receiverNo;
	}
	public void setReceiverNo(String receiverNo) {
		this.receiverNo = receiverNo;
	}

	public String getSealOrder() {
		return this.sealOrder;
	}
	public void setSealOrder(String sealOrder) {
		this.sealOrder = sealOrder;
	}

	public AlsacenterSealPostalInfoDTO getSealPostalInfoDto() {
		return this.sealPostalInfoDto;
	}
	public void setSealPostalInfoDto(AlsacenterSealPostalInfoDTO sealPostalInfoDto) {
		this.sealPostalInfoDto = sealPostalInfoDto;
	}

	public String getSenderName() {
		return this.senderName;
	}
	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public String getSenderNo() {
		return this.senderNo;
	}
	public void setSenderNo(String senderNo) {
		this.senderNo = senderNo;
	}

	public String getSpecialSealInfoMap() {
		return this.specialSealInfoMap;
	}
	public void setSpecialSealInfoMap(String specialSealInfoMap) {
		this.specialSealInfoMap = specialSealInfoMap;
	}

	public String getTakeAwayType() {
		return this.takeAwayType;
	}
	public void setTakeAwayType(String takeAwayType) {
		this.takeAwayType = takeAwayType;
	}

}
