package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 文件项
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:14:22
 */
public class AlsacenterFileSealItemVO extends AlipayObject {

	private static final long serialVersionUID = 5133811371494719643L;

	/**
	 * 电子用印唯一业务标识号
	 */
	@ApiField("business_unique_id")
	private String businessUniqueId;

	/**
	 * 骑缝用印坐标
	 */
	@ApiListField("cross_pos_list")
	@ApiField("alsacenter_seal_coordinate")
	private List<AlsacenterSealCoordinate> crossPosList;

	/**
	 * 是否使用骑缝章    Y("Y", "是"),N("N", "否");
	 */
	@ApiField("cross_seal")
	private String crossSeal;

	/**
	 * 扩展信息map
	 */
	@ApiField("features_map")
	private String featuresMap;

	/**
	 * 用印文件key
	 */
	@ApiField("file_key")
	private String fileKey;

	/**
	 * 文件名
	 */
	@ApiField("file_name")
	private String fileName;

	/**
	 * 用印坐标
	 */
	@ApiListField("pos_list")
	@ApiField("alsacenter_seal_coordinate")
	private List<AlsacenterSealCoordinate> posList;

	/**
	 * 租户
	 */
	@ApiField("tenant")
	private String tenant;

	/**
	 * 电子用印文件编号
	 */
	@ApiField("voucher_id")
	private String voucherId;

	public String getBusinessUniqueId() {
		return this.businessUniqueId;
	}
	public void setBusinessUniqueId(String businessUniqueId) {
		this.businessUniqueId = businessUniqueId;
	}

	public List<AlsacenterSealCoordinate> getCrossPosList() {
		return this.crossPosList;
	}
	public void setCrossPosList(List<AlsacenterSealCoordinate> crossPosList) {
		this.crossPosList = crossPosList;
	}

	public String getCrossSeal() {
		return this.crossSeal;
	}
	public void setCrossSeal(String crossSeal) {
		this.crossSeal = crossSeal;
	}

	public String getFeaturesMap() {
		return this.featuresMap;
	}
	public void setFeaturesMap(String featuresMap) {
		this.featuresMap = featuresMap;
	}

	public String getFileKey() {
		return this.fileKey;
	}
	public void setFileKey(String fileKey) {
		this.fileKey = fileKey;
	}

	public String getFileName() {
		return this.fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public List<AlsacenterSealCoordinate> getPosList() {
		return this.posList;
	}
	public void setPosList(List<AlsacenterSealCoordinate> posList) {
		this.posList = posList;
	}

	public String getTenant() {
		return this.tenant;
	}
	public void setTenant(String tenant) {
		this.tenant = tenant;
	}

	public String getVoucherId() {
		return this.voucherId;
	}
	public void setVoucherId(String voucherId) {
		this.voucherId = voucherId;
	}

}
