package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 电子打印章
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:13:47
 */
public class AlsacenterElecPrintSealDTO extends AlipayObject {

	private static final long serialVersionUID = 7722796798984514479L;

	/**
	 * 期望领件后多久归还
	 */
	@ApiField("delay_days")
	private Long delayDays;

	/**
	 * 文件项集合
	 */
	@ApiListField("file_seal_items_list")
	@ApiField("alsacenter_file_seal_item_v_o")
	private List<AlsacenterFileSealItemVO> fileSealItemsList;

	/**
	 * 打印份数
	 */
	@ApiField("print_nums")
	private Long printNums;

	/**
	 * 打印人姓名
	 */
	@ApiField("printer_name")
	private String printerName;

	/**
	 * 打印人工号
	 */
	@ApiField("printer_work_no")
	private String printerWorkNo;

	public Long getDelayDays() {
		return this.delayDays;
	}
	public void setDelayDays(Long delayDays) {
		this.delayDays = delayDays;
	}

	public List<AlsacenterFileSealItemVO> getFileSealItemsList() {
		return this.fileSealItemsList;
	}
	public void setFileSealItemsList(List<AlsacenterFileSealItemVO> fileSealItemsList) {
		this.fileSealItemsList = fileSealItemsList;
	}

	public Long getPrintNums() {
		return this.printNums;
	}
	public void setPrintNums(Long printNums) {
		this.printNums = printNums;
	}

	public String getPrinterName() {
		return this.printerName;
	}
	public void setPrinterName(String printerName) {
		this.printerName = printerName;
	}

	public String getPrinterWorkNo() {
		return this.printerWorkNo;
	}
	public void setPrinterWorkNo(String printerWorkNo) {
		this.printerWorkNo = printerWorkNo;
	}

}
