package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 签署中心 - 用印状态查询：docusign用印结果
 *
 * @author auto create
 * @since 1.0, 2023-03-22 16:46:11
 */
public class AlsacenterDocusignResult extends AlipayObject {

	private static final long serialVersionUID = 2252365366839238521L;

	/**
	 * 申请人
	 */
	@ApiField("applicant")
	private String applicant;

	/**
	 * 业务方申请单号
	 */
	@ApiField("application_id")
	private String applicationId;

	/**
	 * 申请人部门
	 */
	@ApiField("application_sector")
	private String applicationSector;

	/**
	 * 来源系统
	 */
	@ApiField("application_system")
	private String applicationSystem;

	/**
	 * 申请日期
	 */
	@ApiField("application_time")
	private Date applicationTime;

	/**
	 * 申请类型
	 */
	@ApiField("application_type")
	private String applicationType;

	/**
	 * 审批流程信息
	 */
	@ApiField("approval_flow_info_list")
	private ApprovalFlowInfoVo approvalFlowInfoList;

	/**
	 * 归档公司code
	 */
	@ApiField("archive_company_code")
	private String archiveCompanyCode;

	/**
	 * 归档公司名称
	 */
	@ApiField("archive_company_name")
	private String archiveCompanyName;

	/**
	 * 归档编号
	 */
	@ApiField("archive_num")
	private String archiveNum;

	/**
	 * 归档时间
	 */
	@ApiField("archive_time")
	private Date archiveTime;

	/**
	 * 签约文件证书列表
	 */
	@ApiField("certificate_sign_file_list")
	private AlsacenterAttachmentFileDTO certificateSignFileList;

	/**
	 * ds证书合并签约文件
	 */
	@ApiField("combined_file_vo")
	private AlsacenterAttachmentFileDTO combinedFileVo;

	/**
	 * 合同id
	 */
	@ApiField("contract_id")
	private String contractId;

	/**
	 * 合同基本信息
	 */
	@ApiField("contranct_information")
	private ContractInformationVo contranctInformation;

	/**
	 * 签约文件证书
	 */
	@ApiField("create_e_sign_task_file_vo")
	private AlsacenterAttachmentFileDTO createESignTaskFileVo;

	/**
	 * docusign签约时间
	 */
	@ApiField("e_sign_time")
	private Date eSignTime;

	/**
	 * 失败原因
	 */
	@ApiField("fail_info")
	private String failInfo;

	/**
	 * 处理结果
	 */
	@ApiField("final_status")
	private String finalStatus;

	/**
	 * 法务审批人
	 */
	@ApiField("legal_approver")
	private String legalApprover;

	/**
	 * 非签约文件列表
	 */
	@ApiField("no_sign_file_list")
	private AlsacenterAttachmentFileDTO noSignFileList;

	/**
	 * 对方公司
	 */
	@ApiField("other_company")
	private String otherCompany;

	/**
	 * 签约文件列表
	 */
	@ApiListField("sign_file_list")
	@ApiField("alsacenter_attachment_file_d_t_o")
	private List<AlsacenterAttachmentFileDTO> signFileList;

	/**
	 * 签署状态
	 */
	@ApiField("sign_status")
	private String signStatus;

	/**
	 * 签约文件记录列表
	 */
	@ApiListField("signed_file_info_model_list")
	@ApiField("signed_file_info_d_t_o")
	private List<SignedFileInfoDTO> signedFileInfoModelList;

	/**
	 * 签字人状态
	 */
	@ApiField("signer_dto")
	private RecipientSignStatusResult signerDto;

	/**
	 * 任务处理状态
	 */
	@ApiField("status")
	private String status;

	public String getApplicant() {
		return this.applicant;
	}
	public void setApplicant(String applicant) {
		this.applicant = applicant;
	}

	public String getApplicationId() {
		return this.applicationId;
	}
	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}

	public String getApplicationSector() {
		return this.applicationSector;
	}
	public void setApplicationSector(String applicationSector) {
		this.applicationSector = applicationSector;
	}

	public String getApplicationSystem() {
		return this.applicationSystem;
	}
	public void setApplicationSystem(String applicationSystem) {
		this.applicationSystem = applicationSystem;
	}

	public Date getApplicationTime() {
		return this.applicationTime;
	}
	public void setApplicationTime(Date applicationTime) {
		this.applicationTime = applicationTime;
	}

	public String getApplicationType() {
		return this.applicationType;
	}
	public void setApplicationType(String applicationType) {
		this.applicationType = applicationType;
	}

	public ApprovalFlowInfoVo getApprovalFlowInfoList() {
		return this.approvalFlowInfoList;
	}
	public void setApprovalFlowInfoList(ApprovalFlowInfoVo approvalFlowInfoList) {
		this.approvalFlowInfoList = approvalFlowInfoList;
	}

	public String getArchiveCompanyCode() {
		return this.archiveCompanyCode;
	}
	public void setArchiveCompanyCode(String archiveCompanyCode) {
		this.archiveCompanyCode = archiveCompanyCode;
	}

	public String getArchiveCompanyName() {
		return this.archiveCompanyName;
	}
	public void setArchiveCompanyName(String archiveCompanyName) {
		this.archiveCompanyName = archiveCompanyName;
	}

	public String getArchiveNum() {
		return this.archiveNum;
	}
	public void setArchiveNum(String archiveNum) {
		this.archiveNum = archiveNum;
	}

	public Date getArchiveTime() {
		return this.archiveTime;
	}
	public void setArchiveTime(Date archiveTime) {
		this.archiveTime = archiveTime;
	}

	public AlsacenterAttachmentFileDTO getCertificateSignFileList() {
		return this.certificateSignFileList;
	}
	public void setCertificateSignFileList(AlsacenterAttachmentFileDTO certificateSignFileList) {
		this.certificateSignFileList = certificateSignFileList;
	}

	public AlsacenterAttachmentFileDTO getCombinedFileVo() {
		return this.combinedFileVo;
	}
	public void setCombinedFileVo(AlsacenterAttachmentFileDTO combinedFileVo) {
		this.combinedFileVo = combinedFileVo;
	}

	public String getContractId() {
		return this.contractId;
	}
	public void setContractId(String contractId) {
		this.contractId = contractId;
	}

	public ContractInformationVo getContranctInformation() {
		return this.contranctInformation;
	}
	public void setContranctInformation(ContractInformationVo contranctInformation) {
		this.contranctInformation = contranctInformation;
	}

	public AlsacenterAttachmentFileDTO getCreateESignTaskFileVo() {
		return this.createESignTaskFileVo;
	}
	public void setCreateESignTaskFileVo(AlsacenterAttachmentFileDTO createESignTaskFileVo) {
		this.createESignTaskFileVo = createESignTaskFileVo;
	}

	public Date geteSignTime() {
		return this.eSignTime;
	}
	public void seteSignTime(Date eSignTime) {
		this.eSignTime = eSignTime;
	}

	public String getFailInfo() {
		return this.failInfo;
	}
	public void setFailInfo(String failInfo) {
		this.failInfo = failInfo;
	}

	public String getFinalStatus() {
		return this.finalStatus;
	}
	public void setFinalStatus(String finalStatus) {
		this.finalStatus = finalStatus;
	}

	public String getLegalApprover() {
		return this.legalApprover;
	}
	public void setLegalApprover(String legalApprover) {
		this.legalApprover = legalApprover;
	}

	public AlsacenterAttachmentFileDTO getNoSignFileList() {
		return this.noSignFileList;
	}
	public void setNoSignFileList(AlsacenterAttachmentFileDTO noSignFileList) {
		this.noSignFileList = noSignFileList;
	}

	public String getOtherCompany() {
		return this.otherCompany;
	}
	public void setOtherCompany(String otherCompany) {
		this.otherCompany = otherCompany;
	}

	public List<AlsacenterAttachmentFileDTO> getSignFileList() {
		return this.signFileList;
	}
	public void setSignFileList(List<AlsacenterAttachmentFileDTO> signFileList) {
		this.signFileList = signFileList;
	}

	public String getSignStatus() {
		return this.signStatus;
	}
	public void setSignStatus(String signStatus) {
		this.signStatus = signStatus;
	}

	public List<SignedFileInfoDTO> getSignedFileInfoModelList() {
		return this.signedFileInfoModelList;
	}
	public void setSignedFileInfoModelList(List<SignedFileInfoDTO> signedFileInfoModelList) {
		this.signedFileInfoModelList = signedFileInfoModelList;
	}

	public RecipientSignStatusResult getSignerDto() {
		return this.signerDto;
	}
	public void setSignerDto(RecipientSignStatusResult signerDto) {
		this.signerDto = signerDto;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

}
