package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 签署公司信息
 *
 * @author auto create
 * @since 1.0, 2023-03-22 18:13:56
 */
public class AlsacenterCorpEntity extends AlipayObject {

	private static final long serialVersionUID = 4872299946225714896L;

	/**
	 * 企业支付宝登录账号（类似邮箱或手机号）
	 */
	@ApiField("alipay_account")
	private String alipayAccount;

	/**
	 * 企业名称
	 */
	@ApiField("corp_name")
	private String corpName;

	/**
	 * 签署人类型
PARTA("PARTA", "我方企业"),
PARTB("PARTB", "对方企业");
	 */
	@ApiField("corp_target")
	private String corpTarget;

	/**
	 * 签约通知邮箱
	 */
	@ApiField("notify_email")
	private String notifyEmail;

	public String getAlipayAccount() {
		return this.alipayAccount;
	}
	public void setAlipayAccount(String alipayAccount) {
		this.alipayAccount = alipayAccount;
	}

	public String getCorpName() {
		return this.corpName;
	}
	public void setCorpName(String corpName) {
		this.corpName = corpName;
	}

	public String getCorpTarget() {
		return this.corpTarget;
	}
	public void setCorpTarget(String corpTarget) {
		this.corpTarget = corpTarget;
	}

	public String getNotifyEmail() {
		return this.notifyEmail;
	}
	public void setNotifyEmail(String notifyEmail) {
		this.notifyEmail = notifyEmail;
	}

}
