package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 合同基本信息
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:11:30
 */
public class AlsacenterContractInformationDTO extends AlipayObject {

	private static final long serialVersionUID = 5629148753335459624L;

	/**
	 * 合同id
	 */
	@ApiField("contract_id")
	private String contractId;

	/**
	 * 合同状态
	 */
	@ApiField("contract_status")
	private String contractStatus;

	/**
	 * 合同名称
	 */
	@ApiField("contract_title")
	private String contractTitle;

	/**
	 * 合同描述
	 */
	@ApiField("description")
	private String description;

	/**
	 * 对方公司名称(多个公司用英文逗号隔开)
	 */
	@ApiField("other_company")
	private String otherCompany;

	/**
	 * 我方公司code(多个公司用英文逗号隔开)
	 */
	@ApiField("our_company")
	private String ourCompany;

	public String getContractId() {
		return this.contractId;
	}
	public void setContractId(String contractId) {
		this.contractId = contractId;
	}

	public String getContractStatus() {
		return this.contractStatus;
	}
	public void setContractStatus(String contractStatus) {
		this.contractStatus = contractStatus;
	}

	public String getContractTitle() {
		return this.contractTitle;
	}
	public void setContractTitle(String contractTitle) {
		this.contractTitle = contractTitle;
	}

	public String getDescription() {
		return this.description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	public String getOtherCompany() {
		return this.otherCompany;
	}
	public void setOtherCompany(String otherCompany) {
		this.otherCompany = otherCompany;
	}

	public String getOurCompany() {
		return this.ourCompany;
	}
	public void setOurCompany(String ourCompany) {
		this.ourCompany = ourCompany;
	}

}
