package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 签署文件对象（包含印模和签署区域）
 *
 * @author auto create
 * @since 1.0, 2023-03-23 10:41:30
 */
public class AlsacenterCaSystemSignFileDTO extends AlipayObject {

	private static final long serialVersionUID = 2662385412755721127L;

	/**
	 * 签署区域信息列表（包括印模信息）
	 */
	@ApiListField("ca_system_sign_area_dto_list")
	@ApiField("alsacenter_ca_system_sign_area_d_t_o")
	private List<AlsacenterCaSystemSignAreaDTO> caSystemSignAreaDtoList;

	/**
	 * 签署文件id
	 */
	@ApiField("file_id")
	private String fileId;

	/**
	 * 文件OSS地址
	 */
	@ApiField("file_key")
	private String fileKey;

	/**
	 * 文件名称
	 */
	@ApiField("file_name")
	private String fileName;

	public List<AlsacenterCaSystemSignAreaDTO> getCaSystemSignAreaDtoList() {
		return this.caSystemSignAreaDtoList;
	}
	public void setCaSystemSignAreaDtoList(List<AlsacenterCaSystemSignAreaDTO> caSystemSignAreaDtoList) {
		this.caSystemSignAreaDtoList = caSystemSignAreaDtoList;
	}

	public String getFileId() {
		return this.fileId;
	}
	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getFileKey() {
		return this.fileKey;
	}
	public void setFileKey(String fileKey) {
		this.fileKey = fileKey;
	}

	public String getFileName() {
		return this.fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

}
