package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 签署区域信息（包括印模信息）
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:08:35
 */
public class AlsacenterCaSystemSignAreaDTO extends AlipayObject {

	private static final long serialVersionUID = 7497578689576865358L;

	/**
	 * 骑缝章信息
	 */
	@ApiField("ca_system_cross_page_dto")
	private AlsacenterCaSystemCrossPageDTO caSystemCrossPageDto;

	/**
	 * 正文章信息
	 */
	@ApiField("ca_system_main_body_dto")
	private AlsacenterCaSystemMainBodyDTO caSystemMainBodyDto;

	/**
	 * 用印对齐类型
 TOP_LEFT("TOP_LEFT", "左上角对齐"),
    BOTTOM_LEFT("BOTTOM_LEFT", "左下角对齐"),
    CENTER("CENTER", "xy值是印章的中心"),
    TOP_RIGHT("TOP_RIGHT", "xy值是印章右上角"),
    BOTTOM_RIGHT("BOTTOM_RIGHT", "xy值是印章右下角");
	 */
	@ApiField("location_type")
	private String locationType;

	/**
	 * 签署位置类型，1-正文，2-骑缝
	 */
	@ApiField("position_type")
	private Long positionType;

	/**
	 * 章的旋转角度，顺时针方向旋转，0到360度  ，默认为0
	 */
	@ApiField("rotate_angle")
	private Long rotateAngle;

	/**
	 * 印章id
	 */
	@ApiField("seal_id")
	private String sealId;

	public AlsacenterCaSystemCrossPageDTO getCaSystemCrossPageDto() {
		return this.caSystemCrossPageDto;
	}
	public void setCaSystemCrossPageDto(AlsacenterCaSystemCrossPageDTO caSystemCrossPageDto) {
		this.caSystemCrossPageDto = caSystemCrossPageDto;
	}

	public AlsacenterCaSystemMainBodyDTO getCaSystemMainBodyDto() {
		return this.caSystemMainBodyDto;
	}
	public void setCaSystemMainBodyDto(AlsacenterCaSystemMainBodyDTO caSystemMainBodyDto) {
		this.caSystemMainBodyDto = caSystemMainBodyDto;
	}

	public String getLocationType() {
		return this.locationType;
	}
	public void setLocationType(String locationType) {
		this.locationType = locationType;
	}

	public Long getPositionType() {
		return this.positionType;
	}
	public void setPositionType(Long positionType) {
		this.positionType = positionType;
	}

	public Long getRotateAngle() {
		return this.rotateAngle;
	}
	public void setRotateAngle(Long rotateAngle) {
		this.rotateAngle = rotateAngle;
	}

	public String getSealId() {
		return this.sealId;
	}
	public void setSealId(String sealId) {
		this.sealId = sealId;
	}

}
