package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 正文章信息
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:08:08
 */
public class AlsacenterCaSystemMainBodyDTO extends AlipayObject {

	private static final long serialVersionUID = 7576418149664763867L;

	/**
	 * 关键字
	 */
	@ApiField("key_word")
	private String keyWord;

	/**
	 * CURRENT_PAGE(1, "当前页"),
    ALL_PAGE(2, "所有页");
	 */
	@ApiField("key_word_type")
	private String keyWordType;

	/**
	 * 关键字下标
当传入关键字时，kwIndex不能为空，从1开始，表示第一个命中的关键字；为-1时，表示命中的最后一个关键字
	 */
	@ApiField("kw_index")
	private Long kwIndex;

	/**
	 * 距关键字序号keywordIndex的关键字的中心坐标X轴的偏移量，默认值0
	 */
	@ApiField("kw_shift_x")
	private Long kwShiftX;

	/**
	 * 距关键字序号keywordIndex的关键字的坐标Y轴的偏移量，默认值0
	 */
	@ApiField("kw_shift_y")
	private Long kwShiftY;

	/**
	 * 正文章模式
    KEY_WORD("KEY_WORD", "关键字模式"),
    ABSOLUTE_POSITION("ABSOLUTE_POSITION", "绝对坐标模式");
	 */
	@ApiField("main_body_model")
	private String mainBodyModel;

	/**
	 * 签署页码
	 */
	@ApiField("pos_page")
	private Long posPage;

	/**
	 * 签署区位置横坐标
	 */
	@ApiField("pos_x")
	private Long posX;

	/**
	 * 签署区位置纵坐标
	 */
	@ApiField("pos_y")
	private Long posY;

	public String getKeyWord() {
		return this.keyWord;
	}
	public void setKeyWord(String keyWord) {
		this.keyWord = keyWord;
	}

	public String getKeyWordType() {
		return this.keyWordType;
	}
	public void setKeyWordType(String keyWordType) {
		this.keyWordType = keyWordType;
	}

	public Long getKwIndex() {
		return this.kwIndex;
	}
	public void setKwIndex(Long kwIndex) {
		this.kwIndex = kwIndex;
	}

	public Long getKwShiftX() {
		return this.kwShiftX;
	}
	public void setKwShiftX(Long kwShiftX) {
		this.kwShiftX = kwShiftX;
	}

	public Long getKwShiftY() {
		return this.kwShiftY;
	}
	public void setKwShiftY(Long kwShiftY) {
		this.kwShiftY = kwShiftY;
	}

	public String getMainBodyModel() {
		return this.mainBodyModel;
	}
	public void setMainBodyModel(String mainBodyModel) {
		this.mainBodyModel = mainBodyModel;
	}

	public Long getPosPage() {
		return this.posPage;
	}
	public void setPosPage(Long posPage) {
		this.posPage = posPage;
	}

	public Long getPosX() {
		return this.posX;
	}
	public void setPosX(Long posX) {
		this.posX = posX;
	}

	public Long getPosY() {
		return this.posY;
	}
	public void setPosY(Long posY) {
		this.posY = posY;
	}

}
