package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 签署中心 - 用印状态查询：区块链用印结果
 *
 * @author auto create
 * @since 1.0, 2023-03-22 16:47:22
 */
public class AlsacenterBlockchainResult extends AlipayObject {

	private static final long serialVersionUID = 7542319599341633725L;

	/**
	 * 受理ID
	 */
	@ApiField("accept_id")
	private String acceptId;

	/**
	 * 蚂蚁法链返回的签约ID
	 */
	@ApiField("bas_data_id")
	private String basDataId;

	/**
	 * 业务名称-可空
	 */
	@ApiField("biz_name")
	private String bizName;

	/**
	 * 业务编码-可空
	 */
	@ApiField("biz_no")
	private String bizNo;

	/**
	 * 业务流水号
	 */
	@ApiField("biz_unique_id")
	private String bizUniqueId;

	/**
	 * 签约生效结束日期(yyyy-MM-dd)
	 */
	@ApiField("effect_end_date")
	private Date effectEndDate;

	/**
	 * 签约生效开始日期(yyyy-MM-dd)
	 */
	@ApiField("effect_start_date")
	private Date effectStartDate;

	/**
	 * 签约拒绝或撤销原因
	 */
	@ApiField("refuse_reason")
	private String refuseReason;

	/**
	 * 签约方详情
	 */
	@ApiListField("rela_list")
	@ApiField("block_chain_sign_rela_d_t_o")
	private List<BlockChainSignRelaDTO> relaList;

	/**
	 * 签约时间
	 */
	@ApiField("signed_time")
	private Date signedTime;

	/**
	 * 业务系统租户名称
	 */
	@ApiField("source_sys")
	private String sourceSys;

	/**
	 * 签约状态（FINISHED: 已完成； CANCELLED: 已撤销）
	 */
	@ApiField("status")
	private String status;

	/**
	 * 签约记录哈希地址
	 */
	@ApiField("tx_hash_code")
	private String txHashCode;

	public String getAcceptId() {
		return this.acceptId;
	}
	public void setAcceptId(String acceptId) {
		this.acceptId = acceptId;
	}

	public String getBasDataId() {
		return this.basDataId;
	}
	public void setBasDataId(String basDataId) {
		this.basDataId = basDataId;
	}

	public String getBizName() {
		return this.bizName;
	}
	public void setBizName(String bizName) {
		this.bizName = bizName;
	}

	public String getBizNo() {
		return this.bizNo;
	}
	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getBizUniqueId() {
		return this.bizUniqueId;
	}
	public void setBizUniqueId(String bizUniqueId) {
		this.bizUniqueId = bizUniqueId;
	}

	public Date getEffectEndDate() {
		return this.effectEndDate;
	}
	public void setEffectEndDate(Date effectEndDate) {
		this.effectEndDate = effectEndDate;
	}

	public Date getEffectStartDate() {
		return this.effectStartDate;
	}
	public void setEffectStartDate(Date effectStartDate) {
		this.effectStartDate = effectStartDate;
	}

	public String getRefuseReason() {
		return this.refuseReason;
	}
	public void setRefuseReason(String refuseReason) {
		this.refuseReason = refuseReason;
	}

	public List<BlockChainSignRelaDTO> getRelaList() {
		return this.relaList;
	}
	public void setRelaList(List<BlockChainSignRelaDTO> relaList) {
		this.relaList = relaList;
	}

	public Date getSignedTime() {
		return this.signedTime;
	}
	public void setSignedTime(Date signedTime) {
		this.signedTime = signedTime;
	}

	public String getSourceSys() {
		return this.sourceSys;
	}
	public void setSourceSys(String sourceSys) {
		this.sourceSys = sourceSys;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getTxHashCode() {
		return this.txHashCode;
	}
	public void setTxHashCode(String txHashCode) {
		this.txHashCode = txHashCode;
	}

}
