package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 区块链签约DTO
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:09:28
 */
public class AlsacenterBlockChainDTO extends AlipayObject {

	private static final long serialVersionUID = 3778966245726694745L;

	/**
	 * 当前公司主体经办人信息
	 */
	@ApiField("agent_info")
	private AlsacenterAgentEntityInfo agentInfo;

	/**
	 * 所有签约方企业信息列表
	 */
	@ApiListField("corp_info_multi_list")
	@ApiField("alsacenter_block_chain_corp_entity")
	private List<AlsacenterBlockChainCorpEntity> corpInfoMultiList;

	/**
	 * 签约发起方企业信息
	 */
	@ApiField("init_corp_info")
	private AlsacenterBlockChainCorpEntity initCorpInfo;

	/**
	 * 发起方是否自动签约，true表示是，false表示否
	 */
	@ApiField("is_main_auto_sign")
	private Boolean isMainAutoSign;

	/**
	 * 签约顺序类型: IN_ORDER("IN_ORDER", "顺序签约"),
 NON_ORDER("NON_ORDER", "无序签约");
	 */
	@ApiField("sign_order_type")
	private String signOrderType;

	public AlsacenterAgentEntityInfo getAgentInfo() {
		return this.agentInfo;
	}
	public void setAgentInfo(AlsacenterAgentEntityInfo agentInfo) {
		this.agentInfo = agentInfo;
	}

	public List<AlsacenterBlockChainCorpEntity> getCorpInfoMultiList() {
		return this.corpInfoMultiList;
	}
	public void setCorpInfoMultiList(List<AlsacenterBlockChainCorpEntity> corpInfoMultiList) {
		this.corpInfoMultiList = corpInfoMultiList;
	}

	public AlsacenterBlockChainCorpEntity getInitCorpInfo() {
		return this.initCorpInfo;
	}
	public void setInitCorpInfo(AlsacenterBlockChainCorpEntity initCorpInfo) {
		this.initCorpInfo = initCorpInfo;
	}

	public Boolean getIsMainAutoSign() {
		return this.isMainAutoSign;
	}
	public void setIsMainAutoSign(Boolean isMainAutoSign) {
		this.isMainAutoSign = isMainAutoSign;
	}

	public String getSignOrderType() {
		return this.signOrderType;
	}
	public void setSignOrderType(String signOrderType) {
		this.signOrderType = signOrderType;
	}

}
