package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 签约发起方企业信息
 *
 * @author auto create
 * @since 1.0, 2023-03-22 17:09:44
 */
public class AlsacenterBlockChainCorpEntity extends AlipayObject {

	private static final long serialVersionUID = 4231284554218516911L;

	/**
	 * 企业支付宝账号对应的2088账号
	 */
	@ApiField("account_uid")
	private String accountUid;

	/**
	 * 企业支付宝登录账号
	 */
	@ApiField("alipay_account")
	private String alipayAccount;

	/**
	 * 企业统一社会信用编码
	 */
	@ApiField("corp_code")
	private String corpCode;

	/**
	 * 企业名称
	 */
	@ApiField("corp_name")
	private String corpName;

	/**
	 * 公司关联类型, 指是蚂蚁系公司 or 外部公司
PART_MAIN("MAIN", "我方公司"),
PART_RELA("RELA", "外部关联公司");
	 */
	@ApiField("corp_type")
	private String corpType;

	/**
	 * 法人姓名
	 */
	@ApiField("legal_person_cert_name")
	private String legalPersonCertName;

	/**
	 * 法人证件号
	 */
	@ApiField("legal_person_cert_no")
	private String legalPersonCertNo;

	/**
	 * 签约通知邮箱
	 */
	@ApiField("notify_email")
	private String notifyEmail;

	/**
	 * 签约通知方姓名
	 */
	@ApiField("notify_name")
	private String notifyName;

	public String getAccountUid() {
		return this.accountUid;
	}
	public void setAccountUid(String accountUid) {
		this.accountUid = accountUid;
	}

	public String getAlipayAccount() {
		return this.alipayAccount;
	}
	public void setAlipayAccount(String alipayAccount) {
		this.alipayAccount = alipayAccount;
	}

	public String getCorpCode() {
		return this.corpCode;
	}
	public void setCorpCode(String corpCode) {
		this.corpCode = corpCode;
	}

	public String getCorpName() {
		return this.corpName;
	}
	public void setCorpName(String corpName) {
		this.corpName = corpName;
	}

	public String getCorpType() {
		return this.corpType;
	}
	public void setCorpType(String corpType) {
		this.corpType = corpType;
	}

	public String getLegalPersonCertName() {
		return this.legalPersonCertName;
	}
	public void setLegalPersonCertName(String legalPersonCertName) {
		this.legalPersonCertName = legalPersonCertName;
	}

	public String getLegalPersonCertNo() {
		return this.legalPersonCertNo;
	}
	public void setLegalPersonCertNo(String legalPersonCertNo) {
		this.legalPersonCertNo = legalPersonCertNo;
	}

	public String getNotifyEmail() {
		return this.notifyEmail;
	}
	public void setNotifyEmail(String notifyEmail) {
		this.notifyEmail = notifyEmail;
	}

	public String getNotifyName() {
		return this.notifyName;
	}
	public void setNotifyName(String notifyName) {
		this.notifyName = notifyName;
	}

}
