package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 签署人信息
 *
 * @author auto create
 * @since 1.0, 2023-03-23 10:41:15
 */
public class AlsacenterAntSignUserInfoDTO extends AlipayObject {

	private static final long serialVersionUID = 3317496829661315276L;

	/**
	 * 签署文件列表（包含印模和签署区域）
	 */
	@ApiListField("ca_system_sign_file_dto_list")
	@ApiField("alsacenter_ca_system_sign_file_d_t_o")
	private List<AlsacenterCaSystemSignFileDTO> caSystemSignFileDtoList;

	/**
	 * 邮件联系地址
	 */
	@ApiField("email")
	private String email;

	/**
	 * 签署方联系手机号
	 */
	@ApiField("mobile")
	private String mobile;

	/**
	 * 签署顺序
	 */
	@ApiField("order")
	private Long order;

	/**
	 * 是否为我方公司,true,false
	 */
	@ApiField("our_corp")
	private Boolean ourCorp;

	/**
	 * 企业子类型
BUS("BUS", "企业"),
SINGLE("SINGLE", "个体工商户"),
GOV("GOV", "党政机关"),
INST("INST", "事业单位"),
COMMON("COMMON", "社会组织"),
OTHER("OTHER", "其他组织");
	 */
	@ApiField("sign_sub_type")
	private String signSubType;

	/**
	 * 签署方用户ID
	 */
	@ApiField("sign_user_id")
	private String signUserId;

	/**
	 * 用户类型个人 PERSON;机构 ORG
	 */
	@ApiField("sign_user_type")
	private String signUserType;

	/**
	 * 授权签署时的签署人证件号码
	 */
	@ApiField("signer_cert_number")
	private String signerCertNumber;

	/**
	 * 授权签署时的签署人证件类型
CRED_PSN_CH_IDCARD(大陆身份证)
CRED_ORG_USCC(统一社会信用代码)
	 */
	@ApiField("signer_cert_type")
	private String signerCertType;

	/**
	 * 授权签署时的签署人名称
	 */
	@ApiField("signer_name")
	private String signerName;

	public List<AlsacenterCaSystemSignFileDTO> getCaSystemSignFileDtoList() {
		return this.caSystemSignFileDtoList;
	}
	public void setCaSystemSignFileDtoList(List<AlsacenterCaSystemSignFileDTO> caSystemSignFileDtoList) {
		this.caSystemSignFileDtoList = caSystemSignFileDtoList;
	}

	public String getEmail() {
		return this.email;
	}
	public void setEmail(String email) {
		this.email = email;
	}

	public String getMobile() {
		return this.mobile;
	}
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public Long getOrder() {
		return this.order;
	}
	public void setOrder(Long order) {
		this.order = order;
	}

	public Boolean getOurCorp() {
		return this.ourCorp;
	}
	public void setOurCorp(Boolean ourCorp) {
		this.ourCorp = ourCorp;
	}

	public String getSignSubType() {
		return this.signSubType;
	}
	public void setSignSubType(String signSubType) {
		this.signSubType = signSubType;
	}

	public String getSignUserId() {
		return this.signUserId;
	}
	public void setSignUserId(String signUserId) {
		this.signUserId = signUserId;
	}

	public String getSignUserType() {
		return this.signUserType;
	}
	public void setSignUserType(String signUserType) {
		this.signUserType = signUserType;
	}

	public String getSignerCertNumber() {
		return this.signerCertNumber;
	}
	public void setSignerCertNumber(String signerCertNumber) {
		this.signerCertNumber = signerCertNumber;
	}

	public String getSignerCertType() {
		return this.signerCertType;
	}
	public void setSignerCertType(String signerCertType) {
		this.signerCertType = signerCertType;
	}

	public String getSignerName() {
		return this.signerName;
	}
	public void setSignerName(String signerName) {
		this.signerName = signerName;
	}

}
