package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 蚂蚁电子签
 *
 * @author auto create
 * @since 1.0, 2023-03-23 10:40:24
 */
public class AlsacenterAntSignDTO extends AlipayObject {

	private static final long serialVersionUID = 1865822482733369438L;

	/**
	 * 蚂蚁电子签任务列表
	 */
	@ApiListField("ant_sign_center_task_dto_list")
	@ApiField("alsacenter_ant_sign_center_task_d_t_o")
	private List<AlsacenterAntSignCenterTaskDTO> antSignCenterTaskDtoList;

	/**
	 * 签署过期时间,按毫秒来算，默认为3*24*60*60*1000，表示3天
	 */
	@ApiField("expire_date")
	private Long expireDate;

	/**
	 * 是否关联业务:true,false
	 */
	@ApiField("related_business")
	private Boolean relatedBusiness;

	public List<AlsacenterAntSignCenterTaskDTO> getAntSignCenterTaskDtoList() {
		return this.antSignCenterTaskDtoList;
	}
	public void setAntSignCenterTaskDtoList(List<AlsacenterAntSignCenterTaskDTO> antSignCenterTaskDtoList) {
		this.antSignCenterTaskDtoList = antSignCenterTaskDtoList;
	}

	public Long getExpireDate() {
		return this.expireDate;
	}
	public void setExpireDate(Long expireDate) {
		this.expireDate = expireDate;
	}

	public Boolean getRelatedBusiness() {
		return this.relatedBusiness;
	}
	public void setRelatedBusiness(Boolean relatedBusiness) {
		this.relatedBusiness = relatedBusiness;
	}

}
