package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 蚂蚁电子签任务
 *
 * @author auto create
 * @since 1.0, 2023-03-23 10:40:37
 */
public class AlsacenterAntSignCenterTaskDTO extends AlipayObject {

	private static final long serialVersionUID = 1888291651641186275L;

	/**
	 * 待签署文件列表
	 */
	@ApiListField("ant_sign_file_dto_list")
	@ApiField("alsacenter_ant_sign_file_d_t_o")
	private List<AlsacenterAntSignFileDTO> antSignFileDtoList;

	/**
	 * 签署人信息列表
	 */
	@ApiListField("ant_sign_user_info_dto_list")
	@ApiField("alsacenter_ant_sign_user_info_d_t_o")
	private List<AlsacenterAntSignUserInfoDTO> antSignUserInfoDtoList;

	/**
	 * 任务描述
	 */
	@ApiField("description")
	private String description;

	/**
	 * 暂定业务扩展参数Map<String, String>值
	 */
	@ApiField("extra_param")
	private String extraParam;

	/**
	 * 是否关联业务，若为true，则必须传递 CaSignTaskDetailVo信息 默认false
	 */
	@ApiField("related_business")
	private Boolean relatedBusiness;

	/**
	 * 子业务流水号
	 */
	@ApiField("sub_biz_no")
	private String subBizNo;

	public List<AlsacenterAntSignFileDTO> getAntSignFileDtoList() {
		return this.antSignFileDtoList;
	}
	public void setAntSignFileDtoList(List<AlsacenterAntSignFileDTO> antSignFileDtoList) {
		this.antSignFileDtoList = antSignFileDtoList;
	}

	public List<AlsacenterAntSignUserInfoDTO> getAntSignUserInfoDtoList() {
		return this.antSignUserInfoDtoList;
	}
	public void setAntSignUserInfoDtoList(List<AlsacenterAntSignUserInfoDTO> antSignUserInfoDtoList) {
		this.antSignUserInfoDtoList = antSignUserInfoDtoList;
	}

	public String getDescription() {
		return this.description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

	public String getExtraParam() {
		return this.extraParam;
	}
	public void setExtraParam(String extraParam) {
		this.extraParam = extraParam;
	}

	public Boolean getRelatedBusiness() {
		return this.relatedBusiness;
	}
	public void setRelatedBusiness(Boolean relatedBusiness) {
		this.relatedBusiness = relatedBusiness;
	}

	public String getSubBizNo() {
		return this.subBizNo;
	}
	public void setSubBizNo(String subBizNo) {
		this.subBizNo = subBizNo;
	}

}
