package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 文件用印
 *
 * @author auto create
 * @since 1.0, 2023-03-23 10:16:40
 */
public class AlsacenterAesSealDTO extends AlipayObject {

	private static final long serialVersionUID = 6573771795983756952L;

	/**
	 * 骑缝章能力
	 */
	@ApiField("cross_page_seal_vo")
	private AlsacenterCrossPageSealVo crossPageSealVo;

	/**
	 * 是否使用默认签约人,true,false
	 */
	@ApiField("default_seal_operator")
	private Boolean defaultSealOperator;

	/**
	 * 文件id
	 */
	@ApiField("file_id")
	private String fileId;

	/**
	 * 文件fileKey
	 */
	@ApiField("file_key")
	private String fileKey;

	/**
	 * 文件名称
	 */
	@ApiField("file_name")
	private String fileName;

	/**
	 * 是否已是独立部署应用，已在alplatform 配置独立部署印章中心 1：是、 0：不是
	 */
	@ApiField("independent")
	private Long independent;

	/**
	 * 印章页码信息集合
	 */
	@ApiListField("seal_page_info_list")
	@ApiField("alsacenter_seal_page_info")
	private List<AlsacenterSealPageInfo> sealPageInfoList;

	/**
	 * 印章模式，统一模式：固定绝对坐标，指定用印文件页数
；分页模式：指定关键字、绝对坐标，指定用印文件页
	 */
	@ApiField("seal_request_mode")
	private String sealRequestMode;

	/**
	 * ca签名实体 会出现在数字证书里面
	 */
	@ApiListField("second_party_list")
	@ApiField("alsacenter_sign_operator")
	private List<AlsacenterSignOperator> secondPartyList;

	/**
	 * 指定用印文件页数集合
	 */
	@ApiListField("unified_page_index_list")
	@ApiField("number")
	private List<Long> unifiedPageIndexList;

	/**
	 * 固定绝对坐标
	 */
	@ApiField("unified_seal_request_info")
	private AlsacenterSealRequestInfo unifiedSealRequestInfo;

	/**
	 * 用户id
	 */
	@ApiField("user_id")
	private String userId;

	public AlsacenterCrossPageSealVo getCrossPageSealVo() {
		return this.crossPageSealVo;
	}
	public void setCrossPageSealVo(AlsacenterCrossPageSealVo crossPageSealVo) {
		this.crossPageSealVo = crossPageSealVo;
	}

	public Boolean getDefaultSealOperator() {
		return this.defaultSealOperator;
	}
	public void setDefaultSealOperator(Boolean defaultSealOperator) {
		this.defaultSealOperator = defaultSealOperator;
	}

	public String getFileId() {
		return this.fileId;
	}
	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getFileKey() {
		return this.fileKey;
	}
	public void setFileKey(String fileKey) {
		this.fileKey = fileKey;
	}

	public String getFileName() {
		return this.fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Long getIndependent() {
		return this.independent;
	}
	public void setIndependent(Long independent) {
		this.independent = independent;
	}

	public List<AlsacenterSealPageInfo> getSealPageInfoList() {
		return this.sealPageInfoList;
	}
	public void setSealPageInfoList(List<AlsacenterSealPageInfo> sealPageInfoList) {
		this.sealPageInfoList = sealPageInfoList;
	}

	public String getSealRequestMode() {
		return this.sealRequestMode;
	}
	public void setSealRequestMode(String sealRequestMode) {
		this.sealRequestMode = sealRequestMode;
	}

	public List<AlsacenterSignOperator> getSecondPartyList() {
		return this.secondPartyList;
	}
	public void setSecondPartyList(List<AlsacenterSignOperator> secondPartyList) {
		this.secondPartyList = secondPartyList;
	}

	public List<Long> getUnifiedPageIndexList() {
		return this.unifiedPageIndexList;
	}
	public void setUnifiedPageIndexList(List<Long> unifiedPageIndexList) {
		this.unifiedPageIndexList = unifiedPageIndexList;
	}

	public AlsacenterSealRequestInfo getUnifiedSealRequestInfo() {
		return this.unifiedSealRequestInfo;
	}
	public void setUnifiedSealRequestInfo(AlsacenterSealRequestInfo unifiedSealRequestInfo) {
		this.unifiedSealRequestInfo = unifiedSealRequestInfo;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
