package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 家人共享关系同步接口
 *
 * @author auto create
 * @since 1.0, 2022-03-14 11:28:21
 */
public class AlipayUserFamilyShareRelationSyncModel extends AlipayObject {

	private static final long serialVersionUID = 4197454813471635255L;

	/**
	 * 用户的共享关系到期时间
	 */
	@ApiField("expired_date")
	private Date expiredDate;

	/**
	 * 资源内容，例如卡号、订单号
	 */
	@ApiField("resource_content")
	private String resourceContent;

	/**
	 * 资源标识，例如优酷卡 youku_vip_card
	 */
	@ApiField("resource_id")
	private String resourceId;

	/**
	 * 共享关系接入场景，例如优酷卡family_youku_card
	 */
	@ApiField("scene_code")
	private String sceneCode;

	/**
	 * 支付宝家人虚拟ID或者支付宝用户ID
	 */
	@ApiField("sharing_user_id")
	private String sharingUserId;

	/**
	 * 1、archive_user  支付宝家人虚拟uid 
2、alipay_user 支付宝uid
	 */
	@ApiField("sharing_user_type")
	private String sharingUserType;

	/**
	 * 0:无效 1:有效
	 */
	@ApiField("target_status")
	private String targetStatus;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	/**
	 * 关系变更版本号
	 */
	@ApiField("version_no")
	private Long versionNo;

	public Date getExpiredDate() {
		return this.expiredDate;
	}
	public void setExpiredDate(Date expiredDate) {
		this.expiredDate = expiredDate;
	}

	public String getResourceContent() {
		return this.resourceContent;
	}
	public void setResourceContent(String resourceContent) {
		this.resourceContent = resourceContent;
	}

	public String getResourceId() {
		return this.resourceId;
	}
	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
	}

	public String getSceneCode() {
		return this.sceneCode;
	}
	public void setSceneCode(String sceneCode) {
		this.sceneCode = sceneCode;
	}

	public String getSharingUserId() {
		return this.sharingUserId;
	}
	public void setSharingUserId(String sharingUserId) {
		this.sharingUserId = sharingUserId;
	}

	public String getSharingUserType() {
		return this.sharingUserType;
	}
	public void setSharingUserType(String sharingUserType) {
		this.sharingUserType = sharingUserType;
	}

	public String getTargetStatus() {
		return this.targetStatus;
	}
	public void setTargetStatus(String targetStatus) {
		this.targetStatus = targetStatus;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Long getVersionNo() {
		return this.versionNo;
	}
	public void setVersionNo(Long versionNo) {
		this.versionNo = versionNo;
	}

}
