package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 数字身份电子凭证使用记录通知接口	
 *
 * @author auto create
 * @since 1.0, 2021-05-20 17:20:00
 */
public class AlipayUserDigitalidentityUsecertificateNotifyModel extends AlipayObject {

	private static final long serialVersionUID = 2282664695664193565L;

	/**
	 * 用户领取的凭证唯一ID（由机构生成表达唯一性的标识，可唯一对应一个自然人）
	 */
	@ApiField("certificate_id")
	private String certificateId;

	/**
	 * 凭证实例标识（标识某个具体的凭证类型，例如上海身份码，在接入时由支付宝分配）
	 */
	@ApiField("certificate_instance_code")
	private String certificateInstanceCode;

	/**
	 * 拓展字段，JSON格式
	 */
	@ApiField("ext_info")
	private String extInfo;

	public String getCertificateId() {
		return this.certificateId;
	}
	public void setCertificateId(String certificateId) {
		this.certificateId = certificateId;
	}

	public String getCertificateInstanceCode() {
		return this.certificateInstanceCode;
	}
	public void setCertificateInstanceCode(String certificateInstanceCode) {
		this.certificateInstanceCode = certificateInstanceCode;
	}

	public String getExtInfo() {
		return this.extInfo;
	}
	public void setExtInfo(String extInfo) {
		this.extInfo = extInfo;
	}

}
