package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * ApplePay支付鉴权提交
 *
 * @author auto create
 * @since 1.0, 2020-09-16 13:49:27
 */
public class AlipayTradeApplepayAuthenticationSubmitModel extends AlipayObject {

	private static final long serialVersionUID = 2749244643843875164L;

	/**
	 * ApplePay核身鉴权结果，包括：支付密码、用户确认、数字签名
	 */
	@ApiListField("authentication_results")
	@ApiField("authentication_result")
	private List<AuthenticationResult> authenticationResults;

	/**
	 * MEUCIQC6ZavcDYaApfY1RQH9Djwhnm5KJxaDvdyjW0AXVkXWtwIgUX7WZzKJrfKXiBNVHEI++VJlG0Fy0O9Q9sKuXz0UGHw=
	 */
	@ApiField("authentication_results_signature")
	private String authenticationResultsSignature;

	/**
	 * Apple端的设备ID
	 */
	@ApiField("device_identifier")
	private String deviceIdentifier;

	/**
	 * Apple绑定的BundleId
	 */
	@ApiField("dpan_identifier")
	private String dpanIdentifier;

	/**
	 * 交易标识
	 */
	@ApiField("transaction_identifier")
	private String transactionIdentifier;

	public List<AuthenticationResult> getAuthenticationResults() {
		return this.authenticationResults;
	}
	public void setAuthenticationResults(List<AuthenticationResult> authenticationResults) {
		this.authenticationResults = authenticationResults;
	}

	public String getAuthenticationResultsSignature() {
		return this.authenticationResultsSignature;
	}
	public void setAuthenticationResultsSignature(String authenticationResultsSignature) {
		this.authenticationResultsSignature = authenticationResultsSignature;
	}

	public String getDeviceIdentifier() {
		return this.deviceIdentifier;
	}
	public void setDeviceIdentifier(String deviceIdentifier) {
		this.deviceIdentifier = deviceIdentifier;
	}

	public String getDpanIdentifier() {
		return this.dpanIdentifier;
	}
	public void setDpanIdentifier(String dpanIdentifier) {
		this.dpanIdentifier = dpanIdentifier;
	}

	public String getTransactionIdentifier() {
		return this.transactionIdentifier;
	}
	public void setTransactionIdentifier(String transactionIdentifier) {
		this.transactionIdentifier = transactionIdentifier;
	}

}
