package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * msgto不带openid不含中文参数
 *
 * @author auto create
 * @since 1.0, 2022-11-19 13:27:28
 */
public class AlipaySecurityProdMsgtoToSetModel extends AlipayObject {

	private static final long serialVersionUID = 6251976187422414826L;

	/**
	 * 经营范围，特殊可选，Date类型
	 */
	@ApiField("business_scope")
	private Date businessScope;

	/**
	 * 证件号,必选，复杂类型
	 */
	@ApiField("cert_no")
	private JinyouTestThree certNo;

	/**
	 * 座机号码,boolean，可选 示例值false
	 */
	@ApiField("hascode")
	private Boolean hascode;

	/**
	 * 手机号码, number类型，必选
	 */
	@ApiField("mobile")
	private Long mobile;

	/**
	 * 省份,必选，具体类型string，安全等级R0，
	 */
	@ApiField("province_code")
	private String provinceCode;

	/**
	 * 姓名,必选，price类型
	 */
	@ApiField("user_name")
	private String userName;

	public Date getBusinessScope() {
		return this.businessScope;
	}
	public void setBusinessScope(Date businessScope) {
		this.businessScope = businessScope;
	}

	public JinyouTestThree getCertNo() {
		return this.certNo;
	}
	public void setCertNo(JinyouTestThree certNo) {
		this.certNo = certNo;
	}

	public Boolean getHascode() {
		return this.hascode;
	}
	public void setHascode(Boolean hascode) {
		this.hascode = hascode;
	}

	public Long getMobile() {
		return this.mobile;
	}
	public void setMobile(Long mobile) {
		this.mobile = mobile;
	}

	public String getProvinceCode() {
		return this.provinceCode;
	}
	public void setProvinceCode(String provinceCode) {
		this.provinceCode = provinceCode;
	}

	public String getUserName() {
		return this.userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}

}
