package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 场景加密
 *
 * @author auto create
 * @since 1.0, 2020-12-21 17:40:20
 */
public class AlipaySecurityCryptEncryptGetModel extends AlipayObject {

	private static final long serialVersionUID = 7432481773832152399L;

	/**
	 * 调用方AppName,用户获取对应的密钥保护信息
	 */
	@ApiField("app_name")
	private String appName;

	/**
	 * data,使用服务端公钥对原数据进行SM2加密后的数据
	 */
	@ApiField("data")
	private String data;

	/**
	 * factor,不唯一，用于保护随机密钥，使用SM3对字符串进行hash获得。
	 */
	@ApiField("factor")
	private String factor;

	/**
	 * 场景名
	 */
	@ApiField("scene")
	private String scene;

	public String getAppName() {
		return this.appName;
	}
	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getData() {
		return this.data;
	}
	public void setData(String data) {
		this.data = data;
	}

	public String getFactor() {
		return this.factor;
	}
	public void setFactor(String factor) {
		this.factor = factor;
	}

	public String getScene() {
		return this.scene;
	}
	public void setScene(String scene) {
		this.scene = scene;
	}

}
