package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 跨境游店铺操作员同步到A+
 *
 * @author auto create
 * @since 1.0, 2023-04-23 13:54:04
 */
public class AlipayOverseasTravelOperatorSyncModel extends AlipayObject {

	private static final long serialVersionUID = 1231437625553859439L;

	/**
	 * 跨境游店铺操作员拥有的角色id列表
	 */
	@ApiListField("authed_role_codes")
	@ApiField("string")
	private List<String> authedRoleCodes;

	/**
	 * 跨境游店铺操作员邮箱
	 */
	@ApiField("email")
	private String email;

	/**
	 * 跨境游店铺操作员登录标识
	 */
	@ApiField("logon_id")
	private String logonId;

	/**
	 * 跨境游店铺操作员id
	 */
	@ApiField("operator_id")
	private String operatorId;

	/**
	 * 跨境游店铺ownerId
	 */
	@ApiField("owner_id")
	private String ownerId;

	public List<String> getAuthedRoleCodes() {
		return this.authedRoleCodes;
	}
	public void setAuthedRoleCodes(List<String> authedRoleCodes) {
		this.authedRoleCodes = authedRoleCodes;
	}

	public String getEmail() {
		return this.email;
	}
	public void setEmail(String email) {
		this.email = email;
	}

	public String getLogonId() {
		return this.logonId;
	}
	public void setLogonId(String logonId) {
		this.logonId = logonId;
	}

	public String getOperatorId() {
		return this.operatorId;
	}
	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	public String getOwnerId() {
		return this.ownerId;
	}
	public void setOwnerId(String ownerId) {
		this.ownerId = ownerId;
	}

}
