package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 搜索直达服务查询
 *
 * @author auto create
 * @since 1.0, 2022-04-12 18:16:56
 */
public class AlipayOpenSearchBoxfunctionQueryModel extends AlipayObject {

	private static final long serialVersionUID = 2175531533456682565L;

	/**
	 * 品牌id
	 */
	@ApiField("brand_id")
	private String brandId;

	/**
	 * 商户id，代运营模式下传入
	 */
	@ApiField("merchant_id")
	private String merchantId;

	/**
	 * 服务类目编码，如果不传就是查询所有可用类目
	 */
	@ApiField("service_category_code")
	private String serviceCategoryCode;

	/**
	 * 小程序id，brand_id为空时必传
	 */
	@ApiField("target_appid")
	private String targetAppid;

	public String getBrandId() {
		return this.brandId;
	}
	public void setBrandId(String brandId) {
		this.brandId = brandId;
	}

	public String getMerchantId() {
		return this.merchantId;
	}
	public void setMerchantId(String merchantId) {
		this.merchantId = merchantId;
	}

	public String getServiceCategoryCode() {
		return this.serviceCategoryCode;
	}
	public void setServiceCategoryCode(String serviceCategoryCode) {
		this.serviceCategoryCode = serviceCategoryCode;
	}

	public String getTargetAppid() {
		return this.targetAppid;
	}
	public void setTargetAppid(String targetAppid) {
		this.targetAppid = targetAppid;
	}

}
