package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 查询订单列表
 *
 * @author auto create
 * @since 1.0, 2023-03-28 12:13:46
 */
public class AlipayOpenMiniOrderlistQueryModel extends AlipayObject {

	private static final long serialVersionUID = 5339189736461463425L;

	/**
	 * 格式为yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("end_create_time")
	private String endCreateTime;

	/**
	 * 页数，大于等于1
	 */
	@ApiField("page")
	private Long page;

	/**
	 * 每页订单数，最大100
	 */
	@ApiField("page_size")
	private String pageSize;

	/**
	 * 1:desc, 2:asc
	 */
	@ApiField("sort_order")
	private String sortOrder;

	/**
	 * 起始创建时间 格式为yyyy-MM-dd HH:mm:ss。
	 */
	@ApiField("start_create_time")
	private String startCreateTime;

	public String getEndCreateTime() {
		return this.endCreateTime;
	}
	public void setEndCreateTime(String endCreateTime) {
		this.endCreateTime = endCreateTime;
	}

	public Long getPage() {
		return this.page;
	}
	public void setPage(Long page) {
		this.page = page;
	}

	public String getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}

	public String getSortOrder() {
		return this.sortOrder;
	}
	public void setSortOrder(String sortOrder) {
		this.sortOrder = sortOrder;
	}

	public String getStartCreateTime() {
		return this.startCreateTime;
	}
	public void setStartCreateTime(String startCreateTime) {
		this.startCreateTime = startCreateTime;
	}

}
