package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 更新售后
 *
 * @author auto create
 * @since 1.0, 2023-03-25 13:44:42
 */
public class AlipayOpenMiniOrderAftersaleModifyModel extends AlipayObject {

	private static final long serialVersionUID = 8672928936562243395L;

	/**
	 * 是
0:订单存在可售后商品，1:订单所有商品售后完成（订单维度）
	 */
	@ApiField("finish_all_aftersale")
	private String finishAllAftersale;

	/**
	 * 用户的openId
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 订单ID
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 商家自定义售后ID
	 */
	@ApiField("out_aftersale_id")
	private String outAftersaleId;

	/**
	 * 由商家自定义，64个字符以内，仅支持字母、数字、下划线且需保证在商户端不重复。
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/**
	 * 是
0:未受理,1:用户取消,2:商家受理中,3:商家逾期未处理,4:商家拒绝退款,5:商家拒绝退货退款,6:待买家退货,7:退货退款关闭,8:待商家收货,11:商家退款中,12:商家逾期未退款,13:退款完成,14:退货退款完成,15:换货完成,16:待商家发货,17:待用户确认收货,18:商家拒绝换货,19:商家已收到货
	 */
	@ApiField("status")
	private Long status;

	/**
	 * 用户的（与openId二选一）
	 */
	@ApiField("user_id")
	private String userId;

	public String getFinishAllAftersale() {
		return this.finishAllAftersale;
	}
	public void setFinishAllAftersale(String finishAllAftersale) {
		this.finishAllAftersale = finishAllAftersale;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutAftersaleId() {
		return this.outAftersaleId;
	}
	public void setOutAftersaleId(String outAftersaleId) {
		this.outAftersaleId = outAftersaleId;
	}

	public String getOutOrderId() {
		return this.outOrderId;
	}
	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public Long getStatus() {
		return this.status;
	}
	public void setStatus(Long status) {
		this.status = status;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
