package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 创建售后
 *
 * @author auto create
 * @since 1.0, 2023-03-30 13:55:07
 */
public class AlipayOpenMiniOrderAftersaleCreateModel extends AlipayObject {

	private static final long serialVersionUID = 1197547759595544963L;

	/**
	 * 格式为yyyy-MM-dd HH:mm:ss。
发起申请时间，
	 */
	@ApiField("create_time")
	private String createTime;

	/**
	 * 0:订单存在可售后商品，1:订单所有商品售后完成（订单维度）
	 */
	@ApiField("finish_all_aftersale")
	private Long finishAllAftersale;

	/**
	 * 退换商品的信息
	 */
	@ApiListField("item_infos")
	@ApiField("mini_item_info_d_t_o")
	private List<MiniItemInfoDTO> itemInfos;

	/**
	 * 用户的openId
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 订单ID
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 商家自定义售后ID
	 */
	@ApiField("out_aftersale_id")
	private String outAftersaleId;

	/**
	 * 由商家自定义，64个字符以内，仅支持字母、数字、下划线且需保证在商户端不重复。
order_id、out_order_id，二选一
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/**
	 * 商家小程序该售后单的页面path，不存在则使用订单path
	 */
	@ApiField("path")
	private String path;

	/**
	 * 退款金额
	 */
	@ApiField("refund")
	private String refund;

	/**
	 * 退款原因
	 */
	@ApiField("refund_reason")
	private String refundReason;

	/**
	 * 是
0:未受理,1:用户取消,2:商家受理中,3:商家逾期未处理,4:商家拒绝退款,5:商家拒绝退货退款,6:待买家退货,7:退货退款关闭,8:待商家收货,11:商家退款中,12:商家逾期未退款,13:退款完成,14:退货退款完成,15:换货完成,16:待商家发货,17:待用户确认收货,18:商家拒绝换货,19:商家已收到货
	 */
	@ApiField("status")
	private Long status;

	/**
	 * 售后类型，1:退款,2:退款退货,3:换货
	 */
	@ApiField("type")
	private Long type;

	/**
	 * 用户的uid（与openId二选一）
	 */
	@ApiField("user_id")
	private String userId;

	public String getCreateTime() {
		return this.createTime;
	}
	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public Long getFinishAllAftersale() {
		return this.finishAllAftersale;
	}
	public void setFinishAllAftersale(Long finishAllAftersale) {
		this.finishAllAftersale = finishAllAftersale;
	}

	public List<MiniItemInfoDTO> getItemInfos() {
		return this.itemInfos;
	}
	public void setItemInfos(List<MiniItemInfoDTO> itemInfos) {
		this.itemInfos = itemInfos;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutAftersaleId() {
		return this.outAftersaleId;
	}
	public void setOutAftersaleId(String outAftersaleId) {
		this.outAftersaleId = outAftersaleId;
	}

	public String getOutOrderId() {
		return this.outOrderId;
	}
	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public String getPath() {
		return this.path;
	}
	public void setPath(String path) {
		this.path = path;
	}

	public String getRefund() {
		return this.refund;
	}
	public void setRefund(String refund) {
		this.refund = refund;
	}

	public String getRefundReason() {
		return this.refundReason;
	}
	public void setRefundReason(String refundReason) {
		this.refundReason = refundReason;
	}

	public Long getStatus() {
		return this.status;
	}
	public void setStatus(Long status) {
		this.status = status;
	}

	public Long getType() {
		return this.type;
	}
	public void setType(Long type) {
		this.type = type;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
