package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 新增租户接口
 *
 * @author auto create
 * @since 1.0, 2020-03-09 16:36:23
 */
public class AlipayOpenMiniInstAddModel extends AlipayObject {

	private static final long serialVersionUID = 5758236186743112878L;

	/**
	 * 租户code，例如ALIPW3SG
	 */
	@ApiField("inst_code")
	private String instCode;

	/**
	 * 租户名称
	 */
	@ApiField("inst_name")
	private String instName;

	/**
	 * 站点id，对于国际场景即会员账号体系的站点id
	 */
	@ApiListField("site_ids")
	@ApiField("string")
	private List<String> siteIds;

	public String getInstCode() {
		return this.instCode;
	}
	public void setInstCode(String instCode) {
		this.instCode = instCode;
	}

	public String getInstName() {
		return this.instName;
	}
	public void setInstName(String instName) {
		this.instName = instName;
	}

	public List<String> getSiteIds() {
		return this.siteIds;
	}
	public void setSiteIds(List<String> siteIds) {
		this.siteIds = siteIds;
	}

}
