package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 端元数据提交
 *
 * @author auto create
 * @since 1.0, 2020-03-02 21:07:45
 */
public class AlipayOpenMiniBundleSubmitModel extends AlipayObject {

	private static final long serialVersionUID = 5267792156951954178L;

	/**
	 * 安卓最低支持的客户端版本号
	 */
	@ApiField("android_min_client")
	private String androidMinClient;

	/**
	 * 端标识，用于表明端的唯一标识
	 */
	@ApiField("bundle_id")
	private String bundleId;

	/**
	 * 具体描述端信息，接入场景等情况
	 */
	@ApiField("desc")
	private String desc;

	/**
	 * amap
	 */
	@ApiField("english_name")
	private String englishName;

	/**
	 * 租户code
	 */
	@ApiField("inst_code")
	private String instCode;

	/**
	 * ios最低支持的客户端版本号
	 */
	@ApiField("ios_min_client")
	private String iosMinClient;

	/**
	 * 图片地址
	 */
	@ApiField("logo")
	private String logo;

	/**
	 * 端名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 支付宝码规则为 alipays://platformapi/startapp?appId=%s，输入框只需要填入alipays，业务方自定义前缀即可
	 */
	@ApiField("qrcode_prex")
	private String qrcodePrex;

	public String getAndroidMinClient() {
		return this.androidMinClient;
	}
	public void setAndroidMinClient(String androidMinClient) {
		this.androidMinClient = androidMinClient;
	}

	public String getBundleId() {
		return this.bundleId;
	}
	public void setBundleId(String bundleId) {
		this.bundleId = bundleId;
	}

	public String getDesc() {
		return this.desc;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getEnglishName() {
		return this.englishName;
	}
	public void setEnglishName(String englishName) {
		this.englishName = englishName;
	}

	public String getInstCode() {
		return this.instCode;
	}
	public void setInstCode(String instCode) {
		this.instCode = instCode;
	}

	public String getIosMinClient() {
		return this.iosMinClient;
	}
	public void setIosMinClient(String iosMinClient) {
		this.iosMinClient = iosMinClient;
	}

	public String getLogo() {
		return this.logo;
	}
	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getQrcodePrex() {
		return this.qrcodePrex;
	}
	public void setQrcodePrex(String qrcodePrex) {
		this.qrcodePrex = qrcodePrex;
	}

}
